# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: soundconverter
Version: 4.1.1
Release: alt1

Summary: A simple sound converter application for GNOME
License: GPL-3.0-or-later
Group: Sound

URL: https://github.com/kassoulet/soundconverter
VCS: https://github.com/kassoulet/soundconverter.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch

BuildRequires(pre): rpm-macros-python3
BuildRequires: rpm-build-python3
BuildRequires: rpm-build-gir
BuildRequires: intltool
BuildRequires: python3-devel
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3-module-pygobject3
BuildRequires: python3-module-distutils-extra
BuildRequires: gir(Gst) = 1.0
BuildRequires: desktop-file-utils
Requires: gst-plugins-ugly1.0
Requires: gst-plugins-good1.0
Requires: gst-plugins-base1.0
Requires: typelib(Gtk) = 3.0

%description
A simple sound converter application for the GNOME environment.
It reads and writes anything the GStreamer library can.

%prep
%setup
%patch -p1

sed -i 's|@PYTHON_MODULE@|%python3_sitelibdir/%name|' bin/soundconverter

%build
%pyproject_build

%install
%pyproject_install

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Audio \
	--add-category=AudioVideoEditing \
	build/share/applications/%name.desktop

# install locale
mkdir -p %buildroot%_datadir/locale
cp -a build/mo/* %buildroot%_datadir/locale
%find_lang %name

# remove unidentified locale
rm -r %buildroot%_datadir/locale/sr@Latn/

# Cleanup docdir
rm -r %buildroot%_datadir/doc/%name

# cleanup compiled schemas
rm %buildroot%_datadir/glib-2.0/schemas/gschemas.compiled

%files -f %name.lang
%doc AUTHORS README.md
%_bindir/%name
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%version.dist-info
%_datadir/%name
%_datadir/metainfo/%name.appdata.xml
%_datadir/glib-2.0/schemas/*
%_pixmapsdir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/*.svg

%changelog
