%define _localedir %_datadir/locale

Name: sos
Version: 4.6.0
Release: alt4

Summary: A set of tools to gather troubleshooting information from a system
License: GPL-2.0+
Group: System/Configuration/Other
Url: http://github.com/sosreport/sos
Packager: Evgeny Sinelnikov <sin@altlinux.ru>
BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-alt.patch

Provides: sysreport = 1.3.15-8

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%py3_requires pkg_resources magic

%description
Sos is a set of tools that gathers information about system
hardware and configuration. The information can then be used for
diagnostic purposes and debugging. Sos is commonly used to help
support technicians and developers.

%prep
%setup -n %name-%version
%patch -p1

# Quick hotfix for python3.13
grep -rl 'pipes' | xargs sed -i 's/pipes/shlex/g'

%build
%pyproject_build

%install
%pyproject_install
mkdir -p %buildroot%_sysconfdir/sos/{cleaner,presets.d,extras.d,groups.d}
mkdir -p %buildroot%_sbindir
mv %buildroot%_bindir/* %buildroot%_sbindir
mv %buildroot%_prefix/config/sos.conf %buildroot%_sysconfdir/sos/sos.conf
rm -f %buildroot%_defaultdocdir/%name/{AUTHORS,README.md}
rm -f %buildroot%_datadir/licenses/sos/LICENSE
%find_lang %name

# like Fedora does
rm -rf %buildroot/usr/config/

%files -f %name.lang
%doc AUTHORS README.md docs/*
%config(noreplace) %_sysconfdir/sos/sos.conf
%_sbindir/sos
%_sbindir/sosreport
%_sbindir/sos-collector
%dir %_sysconfdir/sos
%dir %_sysconfdir/sos/cleaner
%dir %_sysconfdir/sos/presets.d
%dir %_sysconfdir/sos/extras.d
%dir %_sysconfdir/sos/groups.d
%python3_sitelibdir/sos
%python3_sitelibdir/%{pyproject_distinfo sos}
%_man1dir/sos*.1*
%_man5dir/sos.conf.5*

%changelog
