Name: smcroute
Version: 2.5.7
Release: alt2

Summary: Static Multicast Routing Daemon
License: GPLv2
Group: System/Servers
Url: https://troglobit.com/projects/smcroute/

Source: %name-%version-%release.tar

BuildRequires: libcap-devel libsystemd-devel

%description
SMCRoute is a daemon and command line tool to manipulate the multicast routes
of the Linux kernel. It can be used as an alternative to dynamic multicast
routers like 'mrouted' in situations where (only) static multicast routes
should be maintained and/or no proper IGMP signaling exists.

%define docdir %_defaultdocdir/%name

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
install -pm0755 -D smcroute.init %buildroot%_initdir/smcroute
touch %buildroot%_sysconfdir/smcroute.conf

%post
%post_service %name

%preun
%preun_service %name

%define _systemunitdir %(pkg-config --variable systemdsystemunitdir systemd)

%files
%doc %docdir
%config(noreplace) %_sysconfdir/smcroute.conf
%_initdir/smcroute
%_systemunitdir/smcroute.service

%_sbindir/smcroute
%_sbindir/smcrouted
%_sbindir/smcroutectl

%_man5dir/smcroute.conf.*
%_man8dir/smcrouted.*
%_man8dir/smcroutectl.*

%changelog
