Name: smbldap-tools
Version: 0.9.10
Release: alt1

Summary: User & Group administration tools for Samba-OpenLDAP
License: GPL
Group: System/Configuration/Networking

Url: http://gna.org/projects/smbldap-tools/
Source0: http://download.gna.org/smbldap-tools/packages/%name-%version.tar.gz
Source1: http://kostyalamer.narod.ru/smbldap/smbldap.html
Patch1: smbldap-tools-0.9.2-alt-separate_users_and_groups_in_smbldap_migrate_unix_accounts.patch

Requires: perl >= 5.6, samba, perl-ldap, perl-Crypt-SmbHash, perl-Digest-SHA1, perl-Unicode-MapUTF8, perl-Encode-JP, perl(FindBin.pm), perl(Getopt/Std.pm), perl(MIME/Base64.pm), perl(Net/LDAP.pm), perl(Net/LDAP/LDIF.pm), perl(Unicode/MapUTF8.pm), perl(lib.pm), perl-base
AutoReq: yes, noperl
BuildRequires: samba perl-ldap perl-Crypt-SmbHash perl-Digest-SHA1 perl-Unicode-MapUTF8 perl-Encode-JP perl-podlators

BuildArch: noarch

%description
In settings with OpenLDAP and Samba-LDAP servers, this collection is
useful to add, modify and delete users and groups, and to change
Unix and Samba passwords. In those context they replace the system
tools to manage users, groups and passwords.

%prep
%setup
#patch1 -p1

#Fix podlator section
cat << EOF >> smbldap-config.pl

exit(0);

########################################
=head1 NAME

smbldap-config - Smbldap-config

=head1 DESCRIPTION

The smbldap-config command configure 

=cut

#'
EOF

%autoreconf
%configure

%build
%make_build

%install
%make install DESTDIR=%buildroot
mv doc/migration_scripts/smbldap-migrate-unix-accounts %buildroot%_sbindir/smbldap-migrate-unix-accounts
mv doc/migration_scripts/smbldap-migrate-unix-groups %buildroot%_sbindir/smbldap-migrate-unix-groups

#install configs
mkdir -p %buildroot%_sysconfdir/smbldap-tools
install smbldap.conf %buildroot%_sysconfdir/smbldap-tools/smbldap.conf
install smbldap_bind.conf %buildroot%_sysconfdir/smbldap-tools/smbldap_bind.conf

#install man
mkdir -p %buildroot%_man8dir
cp *.8 %buildroot%_man8dir/

%files
%_sbindir/*
%attr(0644,root,root) %perl_vendor_privlib/*
%doc CONTRIBUTORS COPYING ChangeLog FILES INFRA README INSTALL TODO
%doc doc/*.*
%dir %_sysconfdir/smbldap-tools/
%config(noreplace) %_sysconfdir/smbldap-tools/smbldap.conf
%attr(0600,root,root) %config(noreplace) %_sysconfdir/smbldap-tools/smbldap_bind.conf
%_man8dir/*

%changelog
