# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%ifarch %arm aarch64 ppc64le loongarch64 riscv64 %e2k
%def_without glinject
%else
%def_with glinject
%endif

Name: simplescreenrecorder
Version: 0.4.4.0.23.9559
Release: alt3

Summary: Simple Screen Recording with OpenGL capture

License: GPL-3.0 and ISC and GPL-3.0+ and Zlib
Group: Video
Url: https://www.maartenbaert.be/simplescreenrecorder/
Vcs: git://github.com/MaartenBaert/ssr.git

Source: https://github.com/MaartenBaert/ssr/archive/%version/ssr-%version.tar.gz
Patch0: simplescreenrecorder-0.4.4-alt-hide-window-on-the-screen-recording.patch
Patch1: simplescreenrecorder-0.4.4-alt-fix-russian-translations.patch

BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: libavformat-devel
BuildRequires: libswscale-devel
BuildRequires: libswresample-devel
BuildRequires: pkgconfig(Qt5) >= 5.7.0
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xfixes)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(xi)
BuildRequires: qt5-linguist
BuildRequires: libappstream-glib
BuildRequires: libXinerama-devel
BuildRequires: libv4l-devel
BuildRequires: qt5-tools-devel

Obsoletes: simplescreenrecording

%description
%summary

%prep
%setup -n ssr-%version
%patch0 -p2
%patch1 -p1
f="data/simplescreenrecorder.desktop"
for s in "GenericName=Simple screen recorder" \
	"GenericName[ru]=Запись видео с экрана" \
	"Comment[ru]=Программа записи видео с экрана" ; do
	grep -F -q "${s%%=}" "$f" || echo "$s" >> "$f"
done
echo "NotShowIn=KDE-Wayland" >> data/simplescreenrecorder.desktop
# XXX waiting for support for channels
##sed -i '/#define SSR_USE_AVFRAME_CHANNELS/s/TEST_AV_VERSION.*/TEST_AV_VERSION(LIBAVCODEC, 57, 0, 57, 0)/' src/Global.h

%build
export PATH=%_qt5_bindir:$PATH
%cmake \
    -GNinja \
%ifnarch %ix86 x86_64
    -DENABLE_X86_ASM=FALSE \
%endif
%if_without glinject
    -DWITH_GLINJECT=FALSE \
%endif
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DWITH_QT5=TRUE
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
rm -f %buildroot%_libdir/*.la

%files
%_bindir/*
%if_with glinject
%_libdir/lib*
%endif
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1.*
%_datadir/%name
%_datadir/metainfo/*

%changelog
