Name: siege
Version: 4.1.7
Release: alt1

Summary: An HTTP regression testing/benchmarking utility

License: %gpl2plus
Group: Networking/WWW
Url: http://www.joedog.org/JoeDog/Siege

Packager: Sergey Alembekov <rt@altlinux.ru>

# Source-url: https://github.com/JoeDog/siege/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-licenses

BuildRequires: gcc-c++ libssl-devel
# for mans
BuildRequires: perl-podlators

%description
Siege is a regression test and benchmark utility. It can stress test a
single URL with a user defined number of simulated users, or it can
read many URLs into memory and stress them simultaneously. The program
reports the total number of hits recorded, bytes transferred, response
time, concurrency, and return status. Siege supports HTTP/1.0 and 1.1
protocols, GET and POST directives, cookies, transaction logging, and
basic authentication. Its features are configurable on a per user
basis.

%prep
%setup

%build
utils/bootstrap
%configure \
	--localstatedir=/var \
	--sysconfdir=/etc/siege \
	--exec_prefix= \
	--with-ssl
%make_build

%install
mkdir -p %buildroot/%_sysconfdir/siege
%makeinstall_std

%files
%doc README.md AUTHORS ChangeLog
%dir %_sysconfdir/siege/
%config(noreplace) %_sysconfdir/siege/siegerc
%config(noreplace) %_sysconfdir/siege/urls.txt
%_bindir/bombardment
%_bindir/siege
%_bindir/siege.config
%_bindir/siege2csv.pl
%_man1dir/*

%changelog
