# prevent perl.req to fail
%set_perl_req_method relaxed
%define __spec_autodep_custom_pre export PERL5OPT='-I%buildroot%_datadir/shutter/resources/modules'
# run "buildreq-src --update --spec shutter.spec ." to update BuildRequires below
# note: remove perl(Furl/HTTP.pm) as it is optional dependency from autoimports
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp/Always.pm) perl(Encode.pm) perl(Encode/Locale.pm) perl(File/Copy/Recursive.pm) perl(File/Which.pm) perl(Glib.pm) perl(Glib/Object/Introspection.pm) perl(Glib/Object/Subclass.pm) perl(GooCanvas2.pm) perl(GooCanvas2/CairoTypes.pm) perl(Gtk3.pm) perl(Gtk3/ImageView.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm) perl(Image/Magick.pm) perl(JSON/MaybeXS.pm) perl(LWP/UserAgent.pm) perl(Locale/gettext.pm) perl(Moo.pm) perl(Net/DBus.pm) perl(Net/DBus/Reactor.pm) perl(Net/FTP.pm) perl(Number/Bytes/Human.pm) perl(Pango.pm) perl(Path/Class.pm) perl(Pod/Usage.pm) perl(Proc/Killfam.pm) perl(Proc/Simple.pm) perl(Sort/Naturally.pm) perl(URI.pm) perl(URI/Split.pm) perl(WebService/Gyazo/B.pm) perl(X11/Protocol.pm) perl(XML/Simple.pm) perl(diagnostics.pm)
# END SourceDeps(oneline)
Name: shutter
Version: 0.99.6
Release: alt1

Summary: Shutter is a feature-rich screenshot program
License: GPLv3+
Group: Graphics
Url: http://shutter-project.org/
VCS: https://github.com/shutter-project/shutter.git

Source: shutter-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-perl
BuildRequires: libwnck3-gir

Requires: libwnck3-gir
Requires: perl-GooCanvas2-CairoTypes
Requires: perl-Number-Bytes-Human
Requires: perl-File-Which
Requires: perl-File-Copy-Recursive
Requires: perl-Proc-Simple
Requires: perl-Sort-Naturally
Requires: perl-Regexp-Parser
Requires: perl-Perl-Tidy
Requires: perl-Carp-Always
Requires: perl-GooCanvas2
Requires: libgoocanvas2
Requires: libgoocanvas2-gir
Requires: perl-Moo

%description
Shutter is a feature-rich screenshot program. You can take a screenshot of a
specific area, window, your whole screen, or even a Web site, apply different
effects to it, draw on it to highlight points, and then upload to an image
hosting site, all within one window.

%prep
%setup

subst 's/Application;/Graphics;2DGraphics;RasterGraphics;/' share/applications/shutter.desktop

# in external library
rm share/shutter/resources/modules/X11/Protocol/Ext/XFIXES.pm
%build
./po2mo.sh

%install
install -pDm 755 bin/shutter %buildroot%_bindir/shutter
cp -a share %buildroot/usr

%find_lang shutter
%find_lang --append --output=shutter.lang shutter-plugins shutter-upload-plugins

%files -f shutter.lang
%doc COPYING README
%_bindir/*
%_datadir/shutter
%dir %_datadir/metainfo
%_datadir/metainfo/shutter.metainfo.xml
%_man1dir/*
%_desktopdir/*
%_pixmapsdir/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_iconsdir/hicolor/128x128/*
%_iconsdir/hicolor/192x192/*
%_iconsdir/hicolor/22x22/*
%_iconsdir/hicolor/24x24/*
%_iconsdir/hicolor/256x256/*
%_iconsdir/hicolor/36x36/*
%_iconsdir/hicolor/64x64/*
%_iconsdir/hicolor/72x72/*
%_iconsdir/hicolor/96x96/*
%_iconsdir/hicolor/scalable/*/*
%dir %_iconsdir/HighContrast
%dir %_iconsdir/HighContrast/scalable
%dir %_iconsdir/HighContrast/scalable/apps
%_iconsdir/HighContrast/scalable/apps/shutter*

%changelog
