%set_verify_elf_method unresolved=relaxed
%def_enable snapshot
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Shotwell

%def_enable face_detection
%def_enable check

%define ver_major 0.32
%define api_ver 1.0
%define gst_api_ver 1.0

Name: shotwell
Version: %ver_major.14
Release: alt1

Summary: A digital photo organizer designed for the GNOME desktop environment
Group: Graphics
License: CC-BY-SA-3.0 and LGPL-2.1-or-later
Url: https://wiki.gnome.org/Apps/Shotwell

Vcs: https://gitlab.gnome.org/GNOME/shotwell.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: %name-0.31.3-alt-no-dark-theme-by-default.patch

%define gtk_ver 3.22
%define gexiv_ver 0.12.1
%define soup3_ver 3.0
%define webkit_api_ver 4.1

Requires: dconf
# for video-thumbnailer
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-libav

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: desktop-file-utils yelp-tools /usr/bin/appstream-util
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libsoup-3.0) >= %soup3_ver
BuildRequires: gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: libdconf-devel libdbus-glib-devel libgexiv2-devel >= %gexiv_ver
BuildRequires: libwebp-devel libgphoto2-devel libgudev-devel libjson-glib-devel
BuildRequires: libraw-devel libexif-devel libgomp-devel libavif-devel
BuildRequires: libsqlite3-devel libstdc++-devel pkgconfig(webkit2gtk-%webkit_api_ver)
BuildRequires: libgee0.8-devel gcr-libs-devel gcr-libs-vala
BuildRequires: libgdata-devel libchamplain-gtk3-devel
BuildRequires: libsecret-devel
BuildRequires: libportal-devel libportal-gtk3-devel
%{?_enable_face_detection:BuildRequires: gcc-c++ libopencv-devel}
%{?_enable_check:BuildRequires: python3 dbus}

%description
Shotwell is a digital photo organizer designed for the GNOME desktop
environment.  It allows you to import photos from disk or camera,
organize them in various ways, view them in full-window or fullscreen
mode, and export them to share with others.


%prep
%setup
%patch -b .no_dark_theme

%ifarch %e2k
sed -i 's/(&builder/((GVariantBuilder*)\&builder/' \
  subprojects/shotwell-facedetect/shotwell-facedetect.cpp
%endif

%build
%add_optflags -D_GIT_VERSION=%(echo %version | tr -d .)
%define vala_ver %(rpm -q --qf '%%{VERSION}' vala)
%if "%(rpmvercmp %vala_ver 0.54)" <= "0"
%add_optflags -DEXPORT_DIALOG_DEFAULT_SCALE=1200
%endif
%meson -Dunity_support=false \
       -Dinstall_apport_hook=false \
       %{?_enable_face_detection:-Dface_detection=true}
%nil
#%%meson_build %name-pot %name-update-po
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %name-extras

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/%name-authenticator
%_libexecdir/%name/%name-video-thumbnailer
%_libexecdir/%name/%name-settings-migrator
%_libexecdir/%name/%name-video-metadata-handler
%if_enabled face_detection
%_libexecdir/%name/%name-facedetect
%_datadir/dbus-1/services/%xdg_name.Faces1.service
%dir %_datadir/%name
%_datadir/%name/facedetect/
%endif
%_libdir/lib%name-plugin-common.so.*
%_libdir/lib%name-plugin-dev-%api_ver.so.*
%_libdir/lib%name-authenticator.so.*

%exclude %_libdir/lib%name-*.so

%_libdir/%name/
%_desktopdir/%{xdg_name}*.desktop
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/glib-2.0/schemas/*
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/%name.1.*
%doc AUTHORS COPYING NEWS README* THANKS


%changelog
