Name: setup
Version: 2.2.22
Release: alt1

Summary: Initial set of configuration files
License: GPL-2.0
Group: System/Configuration/Other
BuildArch: noarch
AutoReq: no

Source: %name-%version.tar

Provides: %_sysconfdir/profile.d, %_sysconfdir/X11/profile.d
Conflicts: initscripts < 1:5.49.1-alt1, xorg-x11-xfs < 1:1.0.4-alt2

%description
Initial set of configuration files to be placed into /etc.

%prep
%setup

%build
find -name \*_d |
	while read f; do
		mv -v "$f" "${f%%_d}.d"
	done
mkdir -p etc/X11/profile.d
pushd etc/profile.d
	for f in lang.*; do
		mv "$f" "0$f"
		ln -s "0$f" "$f"
	done
popd

%install
mkdir -p %buildroot%_datadir
cp -a etc %buildroot%_sysconfdir

mv %buildroot%_sysconfdir/base-passwd %buildroot%_datadir/
cp -p %buildroot%_datadir/base-passwd/group.master %buildroot%_sysconfdir/group
cp -p %buildroot%_datadir/base-passwd/passwd.master %buildroot%_sysconfdir/passwd

install -pD -m644 /dev/null %buildroot/var/log/lastlog
install -pD -m644 /dev/null %buildroot/var/log/faillog

echo '%%dir %_sysconfdir/profile.d' >profile.list
find %buildroot%_sysconfdir/profile.d -type f |
	sed -e 's|^%buildroot|%%config(noreplace) |' >>profile.list
find %buildroot%_sysconfdir/profile.d -type l |
	sed -e 's|^%buildroot||' >>profile.list

%files -f profile.list
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/passwd
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/group
%config(noreplace) %_sysconfdir/default-environment
%config(noreplace) %_sysconfdir/exports
%config(noreplace) %_sysconfdir/filesystems
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/fstab
%config(noreplace) %_sysconfdir/host.conf
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/hosts
%config(noreplace) %_sysconfdir/hosts.*
%config(noreplace) %_sysconfdir/inputrc
%config(noreplace) %_sysconfdir/motd
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/printcap
%config(noreplace) %_sysconfdir/profile
%config(noreplace) %_sysconfdir/protocols
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/resolv.conf
%config(noreplace) %_sysconfdir/services
%config(noreplace) %_sysconfdir/shells
%config(noreplace) %attr(600,root,root) %_sysconfdir/securetty
%config(noreplace) %_sysconfdir/X11/profile.d
%ghost /var/log/*
%_datadir/base-passwd

%changelog
