%global import_path github.com/semaphoreui/semaphore
Name:     semaphore
Version:  2.16.45
Release:  alt1

Summary:  Open Source alternative to Ansible Tower
License:  MIT
Group:    Other
Url:      https://github.com/ansible-semaphore/semaphore

ExclusiveArch: %go_arches

Source:   %name-%version.tar

Patch1:   semaphore-2.20.18-alt-show-just-version.patch

BuildRequires(pre): rpm-build-golang
BuildRequires: golang

%description
%summary

%prep
%setup
%patch1 -p1

# next commands need to prepare sources
# apt-get install go-task packr
# go mod vendor
# task deps:fe
# task build:fe
%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export LDFLAGS="${LDFLAGS:-} -X %import_path/util.Ver=%version"
export LDFLAGS="${LDFLAGS:-} -X %import_path/util.Commit="
export LDFLAGS="${LDFLAGS:-} -X %import_path/util.Date="

%golang_prepare

cd .build/src/%import_path
%golang_build cli

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install
mv %buildroot%_bindir/{cli,%name}

mkdir -p %buildroot%_datadir/zsh/site-functions
%buildroot%_bindir/%name completion zsh > %buildroot%_datadir/zsh/site-functions/_%name
mkdir -p %buildroot%_datadir/bash-completion/completions
%buildroot%_bindir/%name completion bash > %buildroot%_datadir/bash-completion/completions/%name
mkdir -p %buildroot%_datadir/fish/vendor_completions.d
%buildroot%_bindir/%name completion fish > %buildroot%_datadir/fish/vendor_completions.d/%name.fish

%check
%buildroot%_bindir/%name version | grep -Eq '[0-9]+\.[0-9]+\.[0-9]+'

%files
%_bindir/%name
%doc README.ALT
%doc *.md
%_datadir/zsh/site-functions/_%name
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/%name.fish

%changelog
