%def_enable snapshot

%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define ver_major 47
%define beta %nil
%define xdg_name org.gnome.Seahorse

%def_disable debug
%def_enable ldap
%def_enable hkp
%def_enable gnome_keyring
%def_enable pkcs11
%def_enable ssh
%def_enable introspection
%def_enable man
%def_enable check

%if_enabled hkp
# disabled by default and will possibly be removed in the future
%def_disable sharing
%endif

Name: seahorse
Version: %ver_major.0.1
Release: alt2%beta

Summary: A password and encryption key manager
License: GPL-2.0-or-later and LGPL-2.1-or-later
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Seahorse

Vcs: https://gitlab.gnome.org/GNOME/seahorse.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.82
%define gtk_ver 3.24
%define soup3_ver 3.0.0
%define secret_ver 0.16
%define avahi_ver 0.6
%define gcr_ver 4.3.90
%define gpgme_ver 1.16
%define adw_ver 1.5
%define gnupg_ver 2.4.0
%define qrencode_ver 4.1.1

Requires: dconf
Requires: gnupg2 > %gnupg_ver gcr4 >= %gcr_ver
Requires: pinentry-x11
%{?_enable_ssh:Requires: openssh-clients}
%{?_enable_sharing:Requires: avahi-daemon}

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson gcc-c++ vala-tools yelp-tools
BuildRequires: gtk-doc
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: gnupg2 >= %gnupg_ver
BuildRequires: libgpgme-devel >= %gpgme_ver
BuildRequires: libgpg-error-devel
BuildRequires: pkgconfig(libqrencode) >= %qrencode_ver
BuildRequires: pkgconfig(pwquality)
%{?_enable_ldap:BuildRequires: libldap-devel}
%{?_enable_hkp:BuildRequires: libsoup3.0-devel >= %soup3_ver}
%{?_enable_gnome_keyring:BuildRequires: libsecret-devel >= %secret_ver}
%{?_enable_pkcs11:BuildRequires: gcr4-libs-devel >= %gcr_ver vapi(gcr-4)}
%{?_enable_sharing:BuildRequires:libsoup3.0-devel >= %soup3_ver libavahi-glib-devel >= %avahi_ver libavahi-devel}
%{?_enable_ssh:BuildRequires: openssh openssh-clients}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk4-gir-devel}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils gcr}

%description
Seahorse is a password and encryption key manager for GNOME desktop.

%prep
%setup -n %name-%version%beta

%build
%meson \
    -Dprofile=default \
    %{subst_enable_meson_bool ldap ldap-support} \
    %{subst_enable_meson_bool pkcs11 pkcs11-support} \
    %{subst_enable_meson_bool hkp hkp-support} \
    %{subst_enable_meson_bool sharing key-sharing} \
    %{subst_enable_meson_bool man manpage}
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ssh-askpass
%_libexecdir/%name/xloadimage
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*/*/*.*
%_desktopdir/%xdg_name.desktop
%{?_enable_man:%_man1dir/*}
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/seahorse-search-provider.ini
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.window.gschema.xml
%_datadir/metainfo/%{xdg_name}.metainfo.xml
%doc NEWS README* THANKS

%changelog
