Name: seafile-client
Version: 9.0.14
Release: alt1

Summary: Seafile client GUI (Qt-based)

License: Apache License
Group: Networking/File transfer
Url: https://github.com/haiwen/seafile-client

# Source0-url: https://github.com/haiwen/seafile-client/archive/v%version.tar.gz
Source0: %name-%version.tar
Source1: com.seafile.seafile-applet.desktop

Patch0: seafile-client-no-return-error.patch
Patch1: 86ebea086c6b78738b3140c922c909331d2b9a94.patch
Patch2: alt-qt69.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: doxygen graphviz

BuildRequires(pre): rpm-macros-qt6-webengine

# use qt6-webengine or qt5-webkit
%ifarch %qt6_qtwebengine_arches
BuildRequires: rpm-macros-qt6
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(Qt6Linguist)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6Core5Compat)
BuildRequires: pkgconfig(Qt6WebEngineCore)
BuildRequires: pkgconfig(Qt6WebEngineWidgets)
%else
BuildRequires: qt5-tools-devel
BuildRequires: qt5-base-devel
%endif

BuildRequires: libseafile-devel >= %version

# see CMakeLists.txt
BuildRequires: pkgconfig(sqlite3) >= 3.0.0
BuildRequires: pkgconfig(jansson) >= 2.2.1
BuildRequires: pkgconfig(libsearpc) >= 1.0
BuildRequires: pkgconfig(openssl) >= 0.98
#BuildRequires: pkgconfig(libseafile) >= 1.7
BuildRequires: pkgconfig(libevent) >= 2.0
BuildRequires: pkgconfig(zlib) >= 1.2.0

Requires: seafile >= %EVR

%description
Seafile is a full-fledged document collaboration platform.
This package contains desktop GUI client.

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p1
# https://github.com/haiwen/seafile-client/pull/1346
subst -p '1iADD_DEFINITIONS(-DGLIB_VERSION_MIN_REQUIRED=GLIB_VERSION_2_26)' \
	CMakeLists.txt
subst 's/seafile.desktop/com.seafile.seafile-applet.desktop/' \
	CMakeLists.txt
cp -a %SOURCE1 data/

%build
%ifarch %qt6_qtwebengine_arches
export PATH=%_qt6_bindir:$PATH
%else
export PATH=%_qt5_bindir:$PATH
%endif
%cmake
%cmake_build

%install
%cmakeinstall_std
ln -s seafile-applet %buildroot%_bindir/%name

%find_lang %name

%files -f %name.lang
%_bindir/seafile-applet
%_bindir/%name
%_desktopdir/com.seafile.seafile-applet.desktop
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*

%changelog
