
%define _libexecdir %prefix/libexec
%add_findreq_skiplist %_datadir/sddm/scripts/Xsession

%define sddm_user sddm
%define x11confdir %_sysconfdir/X11
%define sddm_confdir %x11confdir/sddm

Name: sddm
Version: 0.21.0
Release: alt4
%K6init no_altplace man

Group: Graphical desktop/KDE
Summary: Lightweight QML-based display manager
Url: https://github.com/sddm/sddm
License: GPLv2+

Requires: xinitrc xauth
Requires: libqt6-quickcontrols2

Source: %name-%version.tar
Source1: sddm.conf
Source3: ru.ts
Source10: sddm.pam
Source11: sddm-autologin.pam
Source12: sddm-greeter.pam
Source20: Xsetup
Source21: Xstop
# SuSE
Patch10: create_pid_file.patch
# github issues
# ALT
Patch100: alt-defaults.patch
Patch101: alt-systemctl-path.patch
Patch102: alt-systemd-unit.patch
Patch103: alt-show-avatars.patch
Patch104: alt-sddm-etc.locale.conf.patch
Patch105: alt-detect-keyboard.patch
Patch107: alt-sddm-etc.sysconfig.i18n.patch
#
Patch201: alt-sddm-fix-pw-do-not-match.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires: cmake extra-cmake-modules glibc-devel
BuildRequires: libpam-devel libsystemd-devel libudev-devel
BuildRequires: libxcb-devel libXau-devel libXdmcp-devel
BuildRequires: qt6-declarative-devel qt6-tools-devel
BuildRequires: python3-module-docutils

%description
SDDM is a modern display manager for X11 aiming to be fast, simple and beatiful.
It uses modern technologies like QtQuick, which in turn gives the designer the
ability to create smooth, animated user interfaces.

%prep
%setup -n %name-%version
%autopatch -p1

sed -i 's|rst2man2.py|rst2man.py3|' data/man/CMakeLists.txt

%build
%K6build \
    -DDATA_INSTALL_DIR=%_datadir/sddm \
    -DCMAKE_INSTALL_LIBEXECDIR=%_libexecdir/sddm \
    -DLIBEXEC_INSTALL_DIR=%_libexecdir/sddm \
    -DSYSTEMD_SYSTEM_UNIT_DIR=%_unitdir \
    -DENABLE_PAM:BOOL=ON \
    -DENABLE_JOURNALD=ON \
    -DMINIMUM_VT=1 \
    -DSESSION_COMMAND="/etc/X11/Xsession" \
    -DBUILD_MAN_PAGES=ON \
    -DSTATE_DIR="%_localstatedir/sddm" \
    -DRUNTIME_DIR="%_runtimedir/sddm" \
    -DPID_FILE="%_runtimedir/sddm.pid" \
    -DCONFIG_FILE="%sddm_confdir/sddm.conf" \
    -DCONFIG_DIR="%_sysconfdir/sddm.conf.d" \
    -DSYSTEM_CONFIG_DIR="%_datadir/sddm/conf.d" \
    -DQT_IMPORTS_DIR="%_qt6_qmldir" \
    -DDBUS_CONFIG_DIR=%_sysconfdir/dbus-1/system.d \
    -DDBUS_CONFIG_FILENAME="sddm_org.freedesktop.DisplayManager.conf" \
    -DUID_MIN=500 \
    -DBUILD_WITH_QT6=ON \
    -DUID_MAX=32000 

lconvert-qt6 -i data/translations/ru.ts %SOURCE3 -o data/translations/ru.ts.new
rm -f data/translations/ru.ts
mv data/translations/ru.ts{.new,}

%install
%K6install

install -Dm 0644 %SOURCE1 %buildroot%sddm_confdir/sddm.conf
install -d %buildroot%_runtimedir/sddm
install -d %buildroot%_localstatedir/sddm
install -d %buildroot%_sysconfdir/sddm.conf.d
install -d %buildroot%_datadir/sddm/conf.d

install -m 0755 %SOURCE20 %buildroot%sddm_confdir/
install -m 0755 %SOURCE21 %buildroot%sddm_confdir/
rm -f %buildroot%_datadir/sddm/scripts/X*
rm %buildroot%_sysusersdir/sddm.conf

install -p -m 0644 %SOURCE10 %buildroot%_sysconfdir/pam.d/sddm
install -p -m 0644 %SOURCE11 %buildroot%_sysconfdir/pam.d/sddm-autologin
#install -p -m 0644 %SOURCE12 %buildroot%_sysconfdir/pam.d/sddm-greeter

# create default theme
#cp -ar %buildroot%_datadir/sddm/themes/maui %buildroot%_datadir/sddm/themes/default
#sed -i 's|^background=.*|background=%_datadir/design/current/backgrounds/xdm.png|' %buildroot%_datadir/sddm/themes/default/theme.conf
#sed -i 's|^\(Name=.*\)|\1 Default|' %buildroot%_datadir/sddm/themes/default/metadata.desktop
#sed -i 's|^\(Description=.*\)|\1 Default|' %buildroot%_datadir/sddm/themes/default/metadata.desktop

%pre
/usr/sbin/useradd -c 'SDDM service' -s /sbin/nologin -d %_localstatedir/sddm -r %sddm_user 2> /dev/null || :

%files
%doc docs/*.md ChangeLog LICENSE* README* CONTRIBUTORS
%dir %sddm_confdir
%dir %_sysconfdir/sddm.conf.d/
%config(noreplace) %sddm_confdir/*
%config(noreplace) %_sysconfdir/pam.d/sddm*
%config(noreplace) %_sysconfdir/dbus-1/system.d/sddm_org.freedesktop.DisplayManager.conf
%_libexecdir/sddm/
%_bindir/sddm
%_bindir/sddm-greeter-qt6
%_K6qml/*
%_datadir/sddm/
%_man1dir/*.*
%_man5dir/*.*
%attr(0711,root,%sddm_user) %dir %_runtimedir/sddm
%attr(0775,%sddm_user,root) %dir %_localstatedir/sddm
%_unitdir/sddm.service
%_tmpfilesdir/sddm.conf

%changelog
