%def_with rdma
%ifarch armh
%def_without glfs
%else
%def_with glfs
%endif
%ifarch x86_64 aarch64 ppc64el
%def_with rbd
%else
%def_without rbd
%endif

Name: scsitarget-utils
Version: 1.0.97
Release: alt1

Summary: The SCSI target daemon and utility programs
License: GPLv2
Group: System/Configuration/Hardware

URL: https://github.com/fujita/tgt
Vcs: https://github.com/fujita/tgt.git

Source0: %name-%version.tar
Source1: tgt.service
Source2: sysconfig.tgtd
Source3: targets.conf
Source4: sample.conf
Source5: tgtd.conf
Source6: tgt.init

# fedora patches
Patch1: 0002-remove-check-for-xsltproc.patch
Patch2: 0003-default-config.patch

BuildRequires: libxslt docbook-style-xsl xsltproc
BuildRequires: glibc-devel
BuildRequires: libaio-devel
BuildRequires: glibc-kernheaders
BuildRequires: systemd-devel
BuildRequires: perl-Config-General
%{?_with_rdma:BuildRequires: libibverbs-devel librdmacm-devel}
%{?_with_rbd:BuildRequires: ceph-devel}
%{?_with_glfs:BuildRequires: libglusterfs-devel >= 7.6}

Requires: lsof
Requires: sg3_utils

Provides: scsi-target-utils = %version-%release
Provides: tgt = %version-%release
Obsoletes: tgt < %version-%release
Provides: iscsitarget = 1.4.20.2-alt2.1
Obsoletes: iscsitarget < 1.4.20.2-alt2.1

%description
The SCSI target package contains the daemon and tools to setup
a SCSI target. Software iSCSI targets are currently supported.

%package rbd
Summary: Support for the Ceph rbd backstore to scsi-target-utils
Group: System/Configuration/Hardware
Requires: %name = %version-%release

%description rbd
Adds support for the Ceph rbd backstore to scsi-target-utils.

%package gluster
Summary: Support for the Gluster backstore to scsi-target-utils
Group: System/Configuration/Hardware
Requires: %name = %version-%release

%description gluster
Adds support for the Gluster glfs backstore to scsi-target-utils.

%prep
%setup
%autopatch -p1

### FIXME: aarch64 ftbfs workaround with gcc12-12.2.1-alt2 (#322140)
%ifarch aarch64
#sed -i "s/(char \*)siginfo/siginfo/" usr/bs.c
sed -i "s/-Werror/-Wno-error/" usr/Makefile
%endif

%build
sed -i 's|-g -O2 -Wall|%optflags|' Makefile
# to prevent race with mkdir() in xsltproc:
mkdir -p doc/htmlpages
%make_build \
	%{?_with_rdma:ISCSI_RDMA=1} \
	%{?_with_rbd:CEPH_RBD=1} \
	%{?_with_glfs:GLFS_BD=1} \
	SD_NOTIFY=1 \
	libdir=%_libdir/tgt

%install
mkdir -p %buildroot{%_sbindir,%_initdir,%_unitdir,%_sysconfdir/tgt/conf.d,%_sysconfdir/sysconfig,%_man5dir,%_man8dir}
mkdir -p %buildroot%_sysconfdir/tgt/include.d %buildroot%_sysconfdir/tgt/examples

install -p -m 0755 scripts/tgt-setup-lun %buildroot%_sbindir
install -p -m 0644 %SOURCE1 %buildroot%_unitdir
install -p -m 0755 scripts/tgt-admin %buildroot/%_sbindir/tgt-admin
install -p -m 0644 doc/manpages/targets.conf.5 %buildroot/%_man5dir
install -pD -m 0644 doc/manpages/*.8 %buildroot/%_man8dir
install -pD -m 0644 conf/examples/* %buildroot%_sysconfdir/tgt/examples
install -p -m 0600 %SOURCE2 %buildroot%_sysconfdir/sysconfig/tgtd
install -p -m 0600 %SOURCE3 %buildroot%_sysconfdir/tgt
install -p -m 0600 %SOURCE4 %buildroot%_sysconfdir/tgt/conf.d
install -p -m 0600 %SOURCE5 %buildroot%_sysconfdir/tgt
install -p -m 0755 %SOURCE6 %buildroot%_initdir/tgt

pushd usr
%makeinstall_std \
	%{?_with_rdma:ISCSI_RDMA=1} \
	%{?_with_rbd:CEPH_RBD=1} \
	%{?_with_glfs:GLFS_BD=1} \
	SD_NOTIFY=1 \
	sbindir=%_sbindir \
	libdir=%_libdir/tgt

# create and pack in any case
mkdir -p %buildroot%_libdir/tgt/backing-store

%post
%post_service tgt

%preun
%preun_service tgt

%files
%doc LICENSE README.md doc/README.* doc/*.txt doc/htmlpages
%_sbindir/tgtd
%_sbindir/tgtadm
%_sbindir/tgt-setup-lun
%_sbindir/tgt-admin
%_sbindir/tgtimg
%_man5dir/*
%_man8dir/*
%_unitdir/tgt.service
%_initdir/tgt
%dir %_libdir/tgt
%dir %_libdir/tgt/backing-store
%dir %_sysconfdir/tgt
%dir %_sysconfdir/tgt/conf.d
%dir %_sysconfdir/tgt/include.d
%_sysconfdir/tgt/examples
%attr(0600,root,root) %config(noreplace) %_sysconfdir/sysconfig/tgtd
%attr(0600,root,root) %config(noreplace) %_sysconfdir/tgt/targets.conf
%attr(0600,root,root) %config(noreplace) %_sysconfdir/tgt/tgtd.conf
%attr(0600,root,root) %config(noreplace) %_sysconfdir/tgt/conf.d/sample.conf

%if_with rbd
%files rbd
%_libdir/tgt/backing-store/bs_rbd.so
%doc doc/README.rbd
%endif

%if_with glfs
%files gluster
%_libdir/tgt/backing-store/bs_glfs.so
%doc doc/README.glfs
%endif

%changelog
