Name: scribus
Version: 1.7.0
Release: alt5
Epoch: 1

Summary: Desktop Publishing application written in Qt
License: GPLv2+
Group: Publishing

Url: http://www.scribus.net/
Packager: Paul Wolneykien <manowar@altlinux.ru>

##Source-url: https://github.com/scribusproject/scribus/archive/master.zip
# Source-url: http://prdownloads.sf.net/%name/%version/%name-%version.tar.xz
Source: %name-%version.tar
Patch1: scribus-1.5.7-no-execbit-plugins.patch
Patch2: scribus-1.7.0-poppler-25.02-compat.patch
Patch3: scribus-1.7.0-fix-compiling-with-qt-6.9.0.patch
Patch4: 8dcf8d777bd85a0741c455961f2de382e3ed47ec.patch
Patch5: ff6c6abfa8683028e548a269dee6a859b6f63335.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: cmake >= 3.16

BuildRequires(pre): rpm-macros-qt6
BuildRequires: qt6-base-devel
BuildRequires: qt6-5compat-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-declarative-devel
# needs for smiles and emojicons
Requires: qt6-imageformats

# Required from BUILDING file
BuildRequires: libfreetype-devel >= 2.3.0
BuildRequires: libcairo-devel >= 1.14.0
BuildRequires: libharfbuzz-devel >= 1.05
BuildRequires: libicu-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel >= 1.6.0
BuildRequires: libtiff-devel >= 3.6.0
BuildRequires: libxml2-devel >= 2.6.0
BuildRequires: liblcms2-devel >= 2.1
BuildRequires: libpoppler-devel >= 0.62.0
BuildRequires: libpoppler-cpp-devel >= 0.62.0

# Recommended from BUILDING file
BuildRequires: libcups-devel
BuildRequires: fontconfig-devel >= 2.0
BuildRequires: ghostscript >= 9.0
BuildRequires: python3-dev
# tkinter for the font sampler script
BuildRequires: python3-modules-tkinter
# python-imaging for the font sampler preview
BuildRequires: python3-module-Pillow
BuildRequires: libhunspell-devel >= 1.6
# podofo - 0.7.0+ for enhanced Illustrator AI/EPS import, svn versions
BuildRequires: libpodofo-devel >= 0.9.7
# boost used only for 2geom
BuildRequires: boost-devel-headers
BuildRequires: GraphicsMagick
BuildRequires: libGraphicsMagick-c++-devel

# for import filters
BuildRequires: librevenge-devel
BuildRequires: libfreehand-devel
BuildRequires: libcdr-devel
BuildRequires: libmspub-devel >= 0.1
BuildRequires: libpagemaker-devel
BuildRequires: libqxp-devel
BuildRequires: libvisio-devel
BuildRequires: libzmf-devel

# Manually
# (commented out in CMakeFiles.txt)
#BuildRequires: libjxl-devel
BuildRequires: zlib-devel libssl-devel

# TODO: use system libs instead third_party
#BuildPreReq: libhyphen-devel lib2geom-devel

Requires: %name-doc >= %epoch:%version
Requires: %name-data >= %epoch:%version
#Requires: aspell-en

AutoProv:no

%add_verify_elf_skiplist %_libdir/%name/plugins/*.so
%add_findreq_skiplist %_datadir/%name/samples/*
%add_findreq_skiplist %_datadir/%name/scripts/*
%add_findprov_skiplist %_datadir/%name/samples/*
%add_findprov_skiplist %_datadir/%name/scripts/*
%add_python3_path %_datadir/%name/samples
%add_python3_path %_datadir/%name/scripts

%description
Scribus is an desktop open source page layout program with
the aim of producing commercial grade output in PDF and
Postscript, primarily, though not exclusively for Linux.

While the goals of the program are for ease of use and simple easy to
understand tools, Scribus offers support for professional publishing
features, such as CMYK color, easy PDF creation, Encapsulated Postscript
import/export and creation of color separations.

%if 0
%package devel
Summary: Header files for Scribus
Group: Development/C++
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description devel
Header files for Scribus.
%endif

%package data
Summary: Data files of Scribus
Group: Publishing
BuildArch: noarch
Conflicts: %name < %epoch:%version

%description data
Data files of Scribus.

%package doc
Summary: Documentation files for Scribus
Group: Development/Tools
Conflicts: %name < %epoch:%version
BuildArch: noarch

%description doc
%summary

%prep
%setup
%patch1 -p2
%patch2 -p2
%patch3 -p1
%patch4 -p1
%patch5 -p1
# hack to ignore new broken checking
subst 's|hunspell_LIBRARY_DIRS||' cmake/modules/Findhunspell.cmake

%build
%ifarch %e2k
# error: cpio archive too big - 4849M
%define optflags_debug -g0
%endif
%cmake \
%if "%_lib" == "lib64"
	-DWANT_LIB64=true \
%endif
	-DWANT_NORPATH=true \
	-DWANT_DISTROBUILD=true \
	-DWANT_CCACHE=true \
	-DWANT_GRAPHICSMAGICK=true \
	-DWANT_HUNSPELL=true \
	-DWITH_PODOFO=true \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags"

%cmake_build

%install
%cmake_install
rm -rv %buildroot%_libdir/cmake/
rm -v %buildroot%_libdir/libqt6advanceddocking_static.a
rm -rv %buildroot%_includedir/qt6advanceddocking/
rm -rv %buildroot/usr/license

pushd %buildroot%_docdir/%name
for i in $(ls ChangeLog*); do
	bzip2 $i
done
popd

%files
%dir %_docdir/%name
%doc %_docdir/%name/AUTHORS
%doc %_docdir/%name/ChangeLog*
%doc %_docdir/%name/COPYING
%doc %_docdir/%name/README
#doc %_docdir/%name/TODO
%_bindir/%name
%_desktopdir/scribus.desktop
%_datadir/metainfo/scribus.appdata.xml
%_datadir/mime/packages/scribus.xml
%_iconsdir/hicolor/*/apps/scribus.png
%_iconsdir/hicolor/*/mimetypes/application-vnd.scribus.png
%_libdir/%name/
%_man1dir/*
%exclude %_mandir/de
%exclude %_mandir/pl

%files data
%_datadir/%name

#files devel
#doc AUTHORS COPYING
#_includedir/%name

%files doc
%dir %_docdir/%name
#_docdir/%name/BUILDING
#_docdir/%name/NEWS
#_docdir/%name/PACKAGING
%_docdir/%name/LINKS
%_docdir/%name/TRANSLATION
%_docdir/%name/en/
%_docdir/%name/ru/
%exclude %_docdir/%name/de
%exclude %_docdir/%name/it

%changelog
