# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

#set_verify_elf_method relaxed

Name: screengrab
Version: 3.1.0
Release: alt1

Summary: ScreenGrab is a tool for geting screenshots
License: GPL-2.0-only
Group: Graphics

Url: https://github.com/lxqt/screengrab
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: /proc
BuildRequires: cmake
BuildRequires: lxqt2-build-tools
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(Qt6Help)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6WaylandClient)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(Qt6Xdg)
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: libqt6xdg-devel
BuildRequires: plasma6-layer-shell-qt-devel
BuildRequires: libpng-devel
# To generate screengrab.desktop
BuildRequires: perl-YAML-LibYAML-API

%description
ScreenGrab -- program getting screenshots working in Linux and Windows.
The program uses Qt6 and is independent from any desktop environment.
Main features:
    * grab screenshot of desktop
    * working on Window and Linux operating systems
    * save screenshots in PNG and JPEG format
    * grab screenshot with delay (1 - 90 sec)
    * hide its window
    * minimize to system tray and work from at (tray menu)

%prep
%setup
%autopatch -p1

find -type f -print0 | xargs -r0 chmod 644 --

# fix docs directories
sed -i 's|${CMAKE_INSTALL_FULL_DOCDIR}|${CMAKE_INSTALL_FULL_DOCDIR}-%version|g' CMakeLists.txt

%ifarch %e2k
%add_optflags -std=c++11
%endif

%build
%add_optflags -I%_includedir/KF6 -L%_libdir/kf6/devel
%cmake
%cmake_build

%install
%cmake_install

%files
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%_iconsdir/hicolor/scalable/apps/screengrab.svg
%_datadir/metainfo/screengrab.metainfo.xml
%doc CHANGELOG COPYING README.md AUTHORS

%changelog
