%define ver_major 3.6

%def_disable snapshot
%def_enable spec_snapshot
%def_enable check
# use corresponding 3.6.x version
%define testspec_version %ver_major.3

Name: sassc
Version: %ver_major.2
Release: alt1.2

Summary: Wrapper around libsass to compile CSS stylesheet
Group: Text tools
License: MIT
Url: http://github.com/sass/sassc

Vcs: https://github.com/sass/sassc.git

%if_disabled snapshot
Source: %url/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
%if_disabled spec_snapshot
Source1: https://github.com/sass/sass-spec/archive/libsass-%testspec_version/sass-spec-libsass-%testspec_version.tar.gz
%else
# https://github.com/sass/sass-spec.git
Source1: sass-spec-%testspec_version.tar
%endif
Patch1: sassc-3.6.2-alt-file_exists.patch
Patch2: sassc-3.6.2-alt-minitest.patch

BuildRequires: gcc-c++ libsass-devel >= %version
%{?_enable_check:BuildRequires: ruby-minitest gem-hrx gem-file_exists}

%description
SassC is a wrapper around libsass used to generate a useful command-line
application that can be installed and packaged for several operating systems.

%prep
%setup -a 1
mv sass-spec-%{?_disable_spec_snapshot:libsass-}%testspec_version sass-spec
echo %version > VERSION

%patch1 -b .file_exists
%patch2 -b .minitest

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%check
ruby sass-spec/sass-spec.rb --impl libsass -c ./%name

%files
%_bindir/%name
%doc LICENSE Readme.md

%changelog
