%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed,lfs=relaxed

Name:    rustic
Version: 0.10.2
Release: alt1

Summary: rustic - fast, encrypted, deduplicated backups powered by pure Rust
License: Apache-2.0
Group:   Archiving/Backup
Url:     https://rustic.cli.rs/
Vcs:     https://github.com/rustic-rs/rustic

Packager: Mikhail Gordeev <obirvalger@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-rust
BuildRequires: pkgconfig(libzstd)

%description
Rustic is a backup tool that provides fast, encrypted, deduplicated
backups. It reads and writes the restic repo format described in the
design document and can therefore be used as a complete replacement
for restic.

NB: rustic currently is in beta state and misses regression tests.
    It is not recommended to use it for production backups, yet.

%prep
%setup
mkdir -p .cargo
tee -a .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1", "--cfg=rustix_use_libc"]

[env]
ZSTD_SYS_USE_PKG_CONFIG = "1"

[profile.release]
strip = false
%if 0%{!?_is_lp64:1}
lto = false
codegen-units = 16
%endif
EOF

%build
# Default features include 'self-update'.
%rust_build --no-default-features --features webdav,tui

%install
%rust_install
mkdir -p %buildroot%_datadir/zsh/site-functions
mkdir -p %buildroot%_datadir/bash-completion/completions
mkdir -p %buildroot%_datadir/fish/vendor_completions.d
%buildroot%_bindir/%name completions zsh > %buildroot%_datadir/zsh/site-functions/_%name
%buildroot%_bindir/%name completions bash > %buildroot%_datadir/bash-completion/completions/%name
%buildroot%_bindir/%name completions fish > %buildroot%_datadir/fish/vendor_completions.d/%name.fish

%check
%rust_test
%buildroot%_bindir/rustic --version | grep -Fx '%name %version'
ldd %buildroot%_bindir/rustic | grep libzstd.so
grep -sF 'https://cloud-api.yandex.net/v1/disk' %buildroot%_bindir/rustic
## Smoke test.
PATH=%buildroot%_bindir:$PATH
export RUSTIC_PASSWORD=rustic
export RUSTIC_REPOSITORY=/tmp/repo
rustic init
rustic backup --glob='!target' --as-path=/ .
rustic check
rustic restore latest ../x
rustic restore latest --verify-existing ../x
diff -qr --exclude=target . ../x

%files
%define _customdocdir %_docdir/%name
%doc *.md config rustic-docs/src/*
%_bindir/%name
%_datadir/bash-completion/completions/%name
%_datadir/zsh/site-functions/_%name
%_datadir/fish/vendor_completions.d/%name.fish

%changelog
