%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%def_without bootstrap
%def_without bundled_llvm
%def_without debuginfo
%global llvm_version 21.1
%define r_ver 1.76.0

Name: rust
Version: 1.91.1
Release: alt1
Epoch: 1

Summary: The Rust Programming Language
License: Apache-2.0 and MIT
Group: Development/Other
URL: http://www.rust-lang.org/
VCS: https://github.com/rust-lang/rust

# https://static.rust-lang.org/dist/rustc-%version-src.tar.gz
Source: %name-%version.tar
# https://github.com/rust-lang/rust/issues/143735
Patch001: rust-1.89.0-github_issue-strict_stage0_sysroot.patch
# Replace shipped rust-lld with system's lld.
# https://github.com/rust-lang/rust/issues/140473
Patch002: rust-1.89.0-fedora-use_system_lld.patch
# https://github.com/rust-lang/rust/issues/114940
Patch003: rust-1.90.0-alt-dont_copy_libunwind_to_src.patch
# https://bugzilla.altlinux.org/56652
# https://github.com/stanislav-tkach/os_info/pull/428
Patch004: rust-1.91.0-alt-altlinux_output_support.patch

Requires: /proc
Requires: gcc
# This component was removed as of Rust 1.69.0.
# https://github.com/rust-lang/rust/pull/101841
Obsoletes: %name-analysis < 1.69.0

# for gdb python binding
BuildRequires(pre): rpm-build-python3
BuildRequires: /proc
BuildRequires: libstdc++-devel
BuildRequires: libstdc++-devel-static
BuildRequires: curl
BuildRequires: cmake
BuildRequires: binutils
BuildRequires: python3-base
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(libgit2)
BuildRequires: pkgconfig(libssh2)
BuildRequires: pkgconfig(tinfo)
%if_without bundled_llvm
BuildRequires: pkgconfig(libffi)

BuildRequires: clang%{llvm_version}
BuildRequires: clang%{llvm_version}-devel
BuildRequires: clang%{llvm_version}-support
BuildRequires: llvm%{llvm_version}-devel
BuildRequires: lld%{llvm_version}-devel
%else
BuildRequires: gcc-c++
BuildRequires: ninja-build
%endif
%ifarch aarch64
BuildRequires: patchelf
%endif

%if_without bootstrap
BuildRequires: rust
BuildRequires: rust-cargo
%define cargo %_bindir/cargo
%define rustc %_bindir/rustc
%else
%define rustdir %_tmppath/rust
%define cargo %rustdir/bin/cargo
%define rustc %rustdir/bin/rustc
%endif

%ifarch %ix86
%define r_arch i686
%endif
%ifarch x86_64
%define r_arch x86_64
%endif
%ifarch aarch64
%define r_arch aarch64
%endif
%ifarch armh
%define r_arch armv7
%endif
%ifarch ppc64le
%define r_arch powerpc64le
%endif
%ifarch loongarch64
%define r_arch loongarch64
%endif
%ifarch riscv64
%define r_arch riscv64gc
%endif

%ifarch armh
%define abisuff eabihf
%else
%define abisuff %nil
%endif

%define rust_triple %r_arch-unknown-linux-gnu%abisuff
%define _common_libdir %prefix/lib
%define rustlibdir %_common_libdir/rustlib
%define _libexecdir /usr/libexec

# While we don't want to encourage dynamic linking to rust shared libraries, as
# there's no stable ABI, we still need the unallocated metadata (.rustc)
# to support custom-derive plugins like #[proc_macro_derive(Foo)].
%if_without debuginfo
# Since 1.12.0: striping debuginfo damages *.so files
%add_debuginfo_skiplist %_libdir/* %_bindir/* %_libexecdir/*
%add_debuginfo_skiplist %rustlibdir/%rust_triple/bin/*
%add_debuginfo_skiplist %rustlibdir/%rust_triple/lib/*
%endif

%description
Rust is a systems programming language that runs blazingly fast, prevents
segfaults, and guarantees thread safety.

%package gdb
Group: Development/Other
Summary: Run rust compiler under gdb
Requires: %name = %EVR
Requires: gdb
AutoReq: nopython,nopython3
AutoProv: nopython,nopython3

%description gdb
%summary.

%package doc
Summary: Documentation for Rust
Group: Development/Documentation
# NOT BuildArch: noarch
# Note, while docs are mostly noarch, some things do vary by target_arch.

%description doc
This package includes HTML documentation for the Rust programming language and
its standard library.

%package cargo
Summary: The Rust package manager
Group: Development/Tools
Requires: rust

%description cargo
Cargo is a tool that allows Rust projects to declare their various dependencies
and ensure that you'll always get a repeatable build.

%package -n rustfmt
Summary: Tool to find and fix Rust formatting issues
Group: Development/Tools
Requires: rust-cargo = %EVR

%description -n rustfmt
A tool for formatting Rust code according to style guidelines.

%package analyzer
Summary: A Rust compiler front-end for IDEs
Group: Development/Tools
Requires: %name = %EVR
Obsoletes: rls <= 1:1.71.0-alt1

%description analyzer
rust-analyzer is a modular compiler frontend for the Rust language. It
is a part of a larger rls-2.0 effort to create excellent IDE support
for Rust.

%package -n clippy
Summary: Lints to catch common mistakes and improve your Rust code
Group: Development/Tools
License: MPL-2.0
Requires: rust-cargo
Requires: %name = %EVR

%description -n clippy
A collection of lints to catch common mistakes and improve your Rust code.

%package src
Summary: Sources for the Rust standard library
Group: Development/Other
AutoReq: no
AutoProv: no

%description src
This package includes source files for the Rust standard library.  It may be
useful as a reference for code completion tools in various editors.

%package wasm32-unknown-unknown-target
Summary: Static libraries for wasm32-unknown-unknown target support
URL: https://doc.rust-lang.org/rustc/platform-support/wasm32-unknown-unknown.html
Group: Development/Other
Requires: rust
Requires: lld

%description wasm32-unknown-unknown-target
The wasm32-unknown-unknown target is a WebAssembly compilation target
which does not import any functions from the host for the standard
library. This is the "minimal" WebAssembly in the sense of making the
fewest assumptions about the host environment. This target is often
used when compiling to the web or JavaScript environments as there is
no standard for what functions can be imported on the web. This target
can also be useful for creating minimal or bare-bones WebAssembly
binaries.

%prep
%setup
%autopatch -p1

%if_with bootstrap
tar xf .rpm/rust-%r_ver-%rust_triple.tar.gz
mkdir -p %rustdir
pushd rust-%r_ver-%rust_triple
./install.sh --prefix=%rustdir
popd

%ifarch aarch64
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %rustdir/bin/cargo
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %rustdir/bin/rustc
%endif
%endif

# This only affects the transient rust-installer, but let it use our dynamic xz-libs
sed -i -e '/LZMA_API_STATIC/d' src/bootstrap/src/core/build_steps/tool.rs

# The configure macro will modify some autoconf-related files, which upsets
# cargo when it tries to verify checksums in those files.  If we just truncate
# that file list, cargo won't have anything to complain about.
find vendor \
	-name .cargo-checksum.json \
	-exec sed -i -e 's/"files":{[^}]*}/"files":{ }/' '{}' '+'

# Environment.
cat >env.sh <<EOF
export RUST_BACKTRACE=1
export RUSTFLAGS="-Clink-arg=-Wl,-z,relro,-z,now -Clink-args=-fPIC"
%ifarch loongarch64
export RUSTFLAGS="$RUSTFLAGS -Ccode-model=medium"
%endif
export LIBSSH2_SYS_USE_PKG_CONFIG=1
export LIBGIT2_SYS_USE_PKG_CONFIG=1
export DESTDIR="%buildroot"
export ALTWRAP_LLVM_VERSION="%llvm_version"
EOF

. ./env.sh

CLANG_RUNTIME_DIR=`clang -print-runtime-dir`
test -r "$CLANG_RUNTIME_DIR/libclang_rt.profile.a"

# Build configuration.
cat > bootstrap.toml <<EOF
change-id = 146435
include = [
        ".rpm/bootstrap.toml.d/llvm-fork-build.toml"
    ]

[build]
target = ["%rust_triple", "wasm32-unknown-unknown"]
cargo = "%cargo"
rustc = "%rustc"
python = "python3"
submodules = false
docs = true
verbose = 2
vendor = true
extended = true
# Not every target has builtins support.
optimized-compiler-builtins = false
tools = ["cargo", "rustdoc", "rust-analyzer", "clippy", "rustfmt", "src"]
build-stage = 3
test-stage = 3
doc-stage = 3

[install]
prefix = "%prefix"

[rust]
channel = "stable"
download-rustc = false
codegen-tests = false
backtrace = true
jemalloc = false
rpath = false
debug = false
deny-warnings = false
codegen-units = 1
%if_without debuginfo
debuginfo-level = 0
%else
debuginfo-level = 1
%endif
lld = false

[llvm]
%if_without bundled_llvm
link-shared = true

[target.%rust_triple]
cc = "clang"
cxx = "clang++"
ar = "llvm-ar"
ranlib = "llvm-ranlib"
llvm-config = "%_bindir/llvm-config"
profiler = "$CLANG_RUNTIME_DIR/libclang_rt.profile.a"
%ifarch %ix86
optimized-compiler-builtins = false
%else
optimized-compiler-builtins = "$CLANG_RUNTIME_DIR/libclang_rt.builtins.a"
%endif
llvm-libunwind = "no"
%endif
EOF

%build
. ./env.sh

python3 x.py build
python3 x.py doc

%install
. ./env.sh

python3 x.py install

rm -f -- %buildroot/%_libdir/lib*.so.old

# Make sure the shared libraries are in the proper libdir
if [ "%_libdir" != "%_common_libdir" ]; then
	mkdir -pv %buildroot%_libdir
	mv %buildroot%_common_libdir/*.so %buildroot%_libdir
fi

# Remove installer artifacts (manifests, uninstall scripts, etc.)
find %buildroot/%rustlibdir -maxdepth 1 -type f -delete

# We don't actually need to ship any of those python scripts in rust-src anyway.
find %buildroot/%rustlibdir/src -type f -name '*.py' -delete

# Remove old binaries
find %buildroot/%_bindir -type f -name '*.old' -delete

# Drop compiled python
find %buildroot/%rustlibdir/etc -type f -name '*.pyc' -delete
%add_python3_path %rustlibdir/etc

pushd %buildroot%_docdir
mv -v rustc         rustc-%version
mv -v docs          rust-doc-%version
mv -v cargo         rust-cargo-%version
mv -v rustfmt       rustfmt-%version
mv -v clippy        rust-clippy-%version
mv -v rust-analyzer rust-analyzer-%version
popd

%check
. ./env.sh

%if_without bundled_llvm
# ensure that rustc_driver is actually dynamically linked to libLLVM
find %buildroot/%_libdir \
	-name 'librustc_driver-*.so' -execdir objdump -p '{}' '+' |
	grep -qs 'NEEDED.*LLVM'
%endif

export LD_LIBRARY_PATH="%buildroot/%_libdir${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}"

# https://rustc-dev-guide.rust-lang.org/tests/intro.html
failed=
for i in \
	assembly-llvm \
	codegen-llvm \
	codegen-units \
	incremental \
	mir-opt \
	debuginfo \
	crashes \
	coverage \
; do
	: "### rust_src_test: running $i"
	status='done'
	# Temporarily run individual tests just for linux target.
	# Tests for wasm32-unknown-unknown are not supported.

	# "crashes/93237.rs" and "crashes/108499.rs" fail on i586
	# For more info see https://github.com/rust-lang/rust/issues/148482.
	if ! python3 ./x.py test --no-doc --no-fail-fast --target %rust_triple "tests/$i" \
        %ifarch %ix86
            --skip tests/crashes/93237.rs --skip tests/crashes/108499.rs \
        %endif
            %nil
	then
		status='failed'
		failed="$failed $i"
	fi
	: "### rust_src_test: $i $status"
done

if [ -n "$failed" ]; then
	: "### rust_src_test: failure summary: $failed"
	: "### aborting due to test failures"
	exit 1
fi

%clean
%if_with bootstrap
rm -rf %rustdir
%endif

%files
%doc %_docdir/rustc-%version
%_bindir/rustc
%_bindir/rustdoc
%_libdir/lib*.so
%_libexecdir/rust-analyzer-proc-macro-srv
%_sysconfdir/target-spec-json-schema.json
%dir %rustlibdir
%dir %rustlibdir/etc
%rustlibdir/%rust_triple/
%exclude %rustlibdir/etc/*
%_man1dir/rustc.*
%_man1dir/rustdoc.*

%files gdb
%_bindir/rust-gdb
%_bindir/rust-gdbgui
%exclude %_bindir/rust-lldb
%rustlibdir/etc/*
%exclude %rustlibdir/etc/lldb_*

%files doc
%doc %_docdir/rust-doc-%version

%files cargo
%doc %_docdir/rust-cargo-%version
%_bindir/cargo
%_man1dir/cargo*.1*
%_sysconfdir/bash_completion.d/cargo
%_datadir/zsh/site-functions/_cargo

%files -n rustfmt
%doc %_docdir/rustfmt-%version
%_bindir/rustfmt
%_bindir/cargo-fmt

%files analyzer
%doc %_docdir/rust-analyzer-%version
%_bindir/rust-analyzer

%files -n clippy
%doc %_docdir/rust-clippy-%version
%_bindir/cargo-clippy
%_bindir/clippy-driver

%files src
%rustlibdir/src

%files wasm32-unknown-unknown-target
%rustlibdir/wasm32-unknown-unknown/

%changelog
