Name: rtl-sdr
Summary: SDR utilities for Realtek RTL2832 based DVB-T dongles
Version: 2.0.2
Release: alt1
License: GPL-2.0-or-later
Group: Communications
URL: https://osmocom.org/projects/rtl-sdr/wiki/Rtl-sdr
VCS: https://gitea.osmocom.org/sdr/rtl-sdr

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake libusb-devel

%description
This package can turn your RTL2832 based DVB-T dongle into a SDR receiver.

%package devel
Summary: Development files for rtl-sdr
Group: Communications
Requires: %name = %EVR

%description devel
Development files for rtl-sdr.

%prep
%setup
rm -f src/getopt/*
rmdir src/getopt

%build
%cmake -DDETACH_KERNEL_DRIVER=ON
%cmake_build

%install
%cmake_install

# remove static libs
rm -f %buildroot%_libdir/*.a

# Fix udev rules and allow access only to users in uucp group
sed -i 's/GROUP="plugdev"/GROUP="uucp"/' rtl-sdr.rules
install -Dpm 644 rtl-sdr.rules %buildroot%_udevrulesdir/10-rtl-sdr.rules

%files
%doc AUTHORS COPYING
%_bindir/*
%_libdir/*.so.*
%_udevrulesdir/10-rtl-sdr.rules

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/cmake/rtlsdr
%_pkgconfigdir/*.pc

%changelog
