Name: rsh
Version: 0.17
Release: alt6
Serial: 1

Summary: Clients for remote access commands (rsh, rlogin, rcp)
Group: Networking/Remote access
License: BSD
Url: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/

Source0: netkit-rsh-%version.tar.gz
Source1: rexec.pam
Source2: rlogin.pam
Source3: rsh.pam
Source4: rexec-1.5.tar.bz2
Source5: rsh-xinetd
Source6: rlogin-xinetd
Source7: rexec-xinetd
Source8: rshd.control
Source9: rsh.control

Patch1: netkit-rsh-0.17-sectty.patch
# Make rexec installation process working
Patch2: netkit-rsh-0.17-rexec.patch
Patch3: netkit-rsh-0.10-stdarg.patch
# Improve installation process
Patch4: netkit-rsh-0.16-jbj.patch
# Link rshd against libpam
Patch8: netkit-rsh-0.16-jbj4.patch
Patch9: netkit-rsh-0.16-prompt.patch
Patch10: netkit-rsh-0.16-rlogin=rsh.patch
# Improve documentation
Patch11: netkit-rsh-0.16-nokrb.patch
# Remove spurious double-reporting of errors
Patch12: netkit-rsh-0.17-pre20000412-jbj5.patch
# RH #42880
Patch13: netkit-rsh-0.17-userandhost.patch
# Don't strip binaries during installation
Patch14: netkit-rsh-0.17-strip.patch
# RH #67362
Patch15: netkit-rsh-0.17-lfs.patch
# RH #57392
Patch16: netkit-rsh-0.17-chdir.patch
# RH #63806
Patch17: netkit-rsh-0.17-pam-nologin.patch
# RH #135643
Patch19: netkit-rsh-0.17-rexec-netrc.patch
# RH #68590
Patch20: netkit-rsh-0.17-pam-sess.patch
# RH #67361
Patch21: netkit-rsh-0.17-errno.patch
# RH #118630
Patch22: netkit-rsh-0.17-rexec-sig.patch
# RH #135827
Patch23: netkit-rsh-0.17-nohost.patch
# RH #122315
Patch24: netkit-rsh-0.17-ignchld.patch
# RH #146464
Patch25: netkit-rsh-0.17-checkdir.patch
Patch26: netkit-rsh-0.17-pam-conv.patch
# RH #174045
Patch27: netkit-rsh-0.17-rcp-largefile.patch
# RH #174146
Patch28: netkit-rsh-0.17-pam-rhost.patch
# RH #178916
Patch29: netkit-rsh-0.17-rlogin-linefeed.patch
Patch30: netkit-rsh-0.17-ipv6.patch
Patch31: netkit-rsh-0.17-pam_env.patch
Patch33: netkit-rsh-0.17-dns.patch
Patch34: netkit-rsh-0.17-nohostcheck-compat.patch
# RH #448904
Patch35: netkit-rsh-0.17-audit.patch
Patch36: netkit-rsh-0.17-longname.patch
# RH #440867
Patch37: netkit-rsh-0.17-arg_max.patch
Patch38: netkit-rsh-0.17-rh448904.patch
Patch39: netkit-rsh-0.17-rh461903.patch
Patch40: netkit-rsh-0.17-rh473492.patch
Patch41: netkit-rsh-0.17-rh650119.patch
Patch42: netkit-rsh-0.17-rh710987.patch
Patch43: netkit-rsh-0.17-rh784467.patch
Patch44: netkit-rsh-0.17-rh896583.patch
Patch45: netkit-rsh-0.17-rh947213.patch
Patch46: 0001-rshd-use-sockaddr_in-for-non-native-IPv6-clients.patch
Patch47: 0002-rlogind-use-sockaddr_in-for-non-native-IPv6-client.patch
Patch48: netkit-rsh-0.17-ipv6-rexec.patch
Patch49: 0001-rshd-include-missing-header-file.patch
Patch50: 0001-rshd-use-upper-bound-for-cmdbuflen.patch   
Patch51: 0001-rcp-don-t-advance-pointer-returned-from-rcp_basename.patch
Patch52: netkit-rsh-0.17-union-wait.patch
Patch53: netkit-rsh-0.17-cmdbuflen.patch
Patch54: netkit-rsh-0.17-CVE-2019-7282.patch
Patch55: netkit-rsh-0.17-c99.patch
Patch56: netkit-rsh-0.17-c99-2.patch

Patch100: netkit-rsh-0.17-alt-warn.patch

# Automatically added by buildreq on Wed Jan 29 2003
BuildRequires: libncurses-devel libpam-devel libtinfo-devel

%description
The rsh package contains a set of programs which allow users to run
commmands on remote machines, login to other machines and copy files
between machines (rsh, rlogin and rcp).  All three of these commands
use rhosts style authentication.  This package contains the clients
needed for all of these services.

The rsh package might be installed to enable remote access to some
legacy network eqipment lacking encrypted access means (so make sure
you have at least considered crypto approach like openssh implements).

*** PLEASE NOTE ***

Due to the binaries installed SUID root the access to those
is limited to "netadmin" group by default; use control(8)
when amending accordinging to the site policy.

%package server
Summary: Servers for remote access commands (rsh, rlogin, rcp)
Group: System/Servers
Requires: pam >= 0.59

%description server
The rsh-server package contains a set of programs which allow users
to run commmands on remote machines, login to other machines and copy
files between machines (rsh, rlogin and rcp).  All three of these
commands use rhosts style authentication.  This package contains the
servers needed for all of these services.  It also contains a server
for rexec, an alternate method of executing remote commands.
All of these servers are run by xinetd and configured using
/etc/xinetd.d/ and PAM (but are disabled by default).

*** PLEASE NOTE ***

Most probably you don't want this package installed,
it's pretty hard to use it securely enough (or to provide
a trusted enough environment so it's not an issue).

One might be way better off using OpenSSH (probably with
shared connections configured to lower the new connection
setup latency) or maybe HPN-SSH.

To (hopefully) ensure that the sysadmin understands this,
the binaries are shipped with no execute permissions;
control(8) facility is provided to regulate those.

%prep
%setup -n netkit-rsh-%version -a 4
%patch1 -p1 -b .sectty
%patch2 -p1 -b .rexec
%patch3 -p1 -b .stdarg
%patch4 -p1 -b .jbj
%patch8 -p1 -b .jbj4
%patch9 -p1 -b .prompt
%patch10 -p1 -b .rsh
%patch11 -p1 -b .rsh.nokrb
%patch12 -p1 -b .jbj5
%patch13 -p1 -b .userandhost
%patch14 -p1 -b .strip
%patch15 -p1 -b .lfs
%patch16 -p1 -b .chdir
%patch17 -p1 -b .pam-nologin
%patch19 -p1 -b .rexec-netrc
%patch20 -p1 -b .pam-sess
%patch21 -p1 -b .errno
%patch22 -p1 -b .rexec-sig
%patch23 -p1 -b .nohost
%patch24 -p1 -b .ignchld
%patch25 -p1 -b .checkdir
%patch26 -p1 -b .pam-conv
%patch27 -p1 -b .largefile
%patch28 -p1 -b .pam-rhost
%patch29 -p1 -b .linefeed
%patch30 -p1 -b .ipv6
%patch31 -p1 -b .pam_env
%patch33 -p1 -b .dns
%patch34 -p1 -b .compat
%patch35 -p1 -b .audit
%patch36 -p1 -b .longname
%patch37 -p1 -b .arg_max
%patch38 -p1 -b .rh448904
%patch39 -p1 -b .rh461903
%patch40 -p1 -b .rh473492
%patch41 -p1 -b .rh650119
%patch42 -p1 -b .rh710987
%patch43 -p1 -b .rh784467
%patch44 -b .rh896583
%patch45 -p1 -b .rh947213
%patch46 -p1
%patch47 -p1
%patch48 -p1 -b .ipv6-rexec
%patch49 -p1 -b .waitpid
%patch50 -p1
%patch51 -p1
%patch52 -p1 -b .union-wait
%patch53 -p1 -b .cmdbuflen
%patch54 -p1 -b .cve-2019-7282
%patch55 -p1 -b .c99
%patch56 -p1 -b .c99-2

# FIXME: needs rediff
#patch100 -p1 -b .warn

# No, I don't know what this is doing in the tarball.
rm -f rexec/rexec

%build
%_configure_script \
    --without-shadow \
    --prefix=/usr \
    --installroot=%buildroot \
    --binmode=0755 \
    --daemonmode=0711 \
    --suidmode=4711

%add_optflags -fno-strict-aliasing -fpic -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64 -D_GNU_SOURCE


perl -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\%optflags,;
    s,^BINDIR=.*$,BINDIR=%_bindir,;
    s,^MANDIR=.*$,MANDIR=%_mandir,;
    s,^SBINDIR=.*$,SBINDIR=%_sbindir,;
    ' MCONFIG

%make_build

%install
#mkdir -p %buildroot%_sysconfdir/{pam.d,xinetd.d}
mkdir -p %buildroot{%_bindir,%_sbindir}
mkdir -p %buildroot%_mandir/{man1,man8}

%make INSTALLROOT=%buildroot MANDIR=%_mandir install

install -pDm644 %SOURCE1 %buildroot/%_sysconfdir/pam.d/rexec
install -pDm644 %SOURCE2 %buildroot/%_sysconfdir/pam.d/rlogin
install -pDm644 %SOURCE3 %buildroot/%_sysconfdir/pam.d/rsh

install -pDm644 %SOURCE5 %buildroot/%_sysconfdir/xinetd.d/rsh
install -pDm644 %SOURCE6 %buildroot/%_sysconfdir/xinetd.d/rlogin
install -pDm644 %SOURCE7 %buildroot/%_sysconfdir/xinetd.d/rexec

install -pDm755 %SOURCE8 %buildroot%_controldir/rshd
install -pDm755 %SOURCE9 %buildroot%_controldir/rsh

%pre
%_sbindir/groupadd -r -f netadmin >/dev/null 2>&1
%pre_control rsh

%post
%post_control -s netadmin rsh

%pre server
%pre_control rshd

%post server
%post_control -s disabled rshd

%files
%_controldir/rsh
%attr(4710,root,netadmin) %_bindir/rcp
%attr(4710,root,netadmin) %_bindir/rlogin
%attr(4710,root,netadmin) %_bindir/rsh
%_bindir/rexec
%_mandir/man1/*
%doc README

%files server
%_controldir/rshd
%attr(600,root,root) %_sbindir/in.*
%config(noreplace) %_sysconfdir/xinetd.d/*
%config(noreplace) %_sysconfdir/pam.d/*
%_mandir/man8/*

%changelog
