# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1

Name: rpm-macros-zig
Version: 4
Release: alt1
Summary: RPM macros for Zig
License: GPL-2.0-only
Group: Development/Other
BuildArch: noarch

Source: zig.macros

%description
%summary.

%install
install -pDm644 %SOURCE0 %buildroot%_rpmmacrosdir/zig

%check
set +x
grep -Eo '%%\S+' %SOURCE0 | while read -r m; do
	M=$(rpm \
		--macros='/usr/lib/rpm/macros:%SOURCE0' \
		--define 'name for_buildroot' \
		--eval "$m" </dev/null)
	echo -n "check $m [${#M}] "
	if grep -q '%%' <<<"$M"; then
		echo >&2 "unexpandable [$M]"
		exit 2
	elif [ ${#M} -eq 0 ]; then
		echo "empty"
		exit 3
	else
		echo "ok"
	fi
done

%files
%_rpmmacrosdir/zig

%changelog
