# SPDX-License-Identifier: GPL-2.0-only
# Copyright (C) 2019-2023 Vitaly Chikunov <vt@altlinux.org>
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%ifndef _priority_distbranch
# We have it defined in macros but not in buildmacros.
%define _priority_distbranch %(rpm --eval %%_priority_distbranch)
%endif

Name: rpm-build-vm
Version: 1.76
Release: alt1

Summary: RPM helper to run tests in virtualised environment
License: GPL-2.0-only
Group: Development/Other
Url: https://www.altlinux.org/Hasher/vm-run
Vcs: https://github.com/vt-alt/vm-run

Source: %name-%version.tar

%define supported_arches %ix86 x86_64 ppc64le aarch64 armh

%ifarch %supported_arches
BuildRequires(pre): rpm-build-kernel
BuildRequires: glibc-devel-static
BuildRequires: libblkid-devel-static
# For %%check. This does not verify the package but verifies
# that girar on supported_arches have writable /dev/kvm
# This should run even if check is disabled.
BuildRequires: /dev/kvm
# shellchek is used in %%build as pre-install syntax check.
%ifarch %ix86 x86_64
# There is no shellcheck on other arches in p9. 'make shellcheck' below can
# handle absence of shellcheck binary using only 'bash -n'.
BuildRequires: shellcheck
%endif

%if 0%{?kernel_latest:1}
# Sisyphus have even newer kernels than un-def.
Requires(pre): kernel-latest
%else
# Try to load un-def kernel this way to avoid "forbidden dependencies"
# from sisyphus_check.
# `>= 5.7` is to avoid kernel-image-xenomai.
Requires(pre): kernel >= 5.7
%endif
%endif

Requires(pre): %name-run = %EVR

%ifarch %supported_arches
%description
RPM helper to run QEMU inside hasher. This is mainly intended
for %%check section to test software under better emulated root
than fakeroot.

This is similar to multiple vm scripts, virtme, vido, and eudyptula-boot.
%else
%description
This package is a stub instead of RPM helper to run QEMU inside hasher
on supported architectures (this one (%_arch) is unsupported).
%endif

%package run
Summary: vm-run virtualized runner
Group: Development/Other
# Due to /usr/sbin/kvm-ok
Conflicts: cpu-checker

# Other arches will get a stub which will always return success
%ifarch %supported_arches
Requires: mount

# /proc is required for qemu 9p to work, otherwise you'll get
# confusing ENOENT when creating a file. This is because
# `qemu/hw/9pfs/9p-local.c:fchmodat_nofollow' is doing chmod
# over `/proc/self/fd/%%d'.
Requires: /proc
Requires: /dev/kvm

%ifarch %ix86 x86_64
Requires: qemu-system-x86-core
%endif
%ifarch ppc64le
Requires: qemu-system-ppc-core
%endif
%ifarch aarch64
Requires: qemu-system-aarch64-core
%endif
%ifarch armh
# No KVM support in the kernel for this arch.
Requires: qemu-system-arm-core
# AArch64-native qemu-system-aarch64 binary to use KVM.
Requires: qemu-system-aarch64-core-bundle
%endif

%endif

%ifarch %supported_arches
%description run
RPM helper to run QEMU inside hasher. This is mainly intended
for %%check section to test software under better emulated root
than fakeroot.

This is similar to multiple vm scripts, virtme, vido, and eudyptula-boot.

This package is vm-run scripts only (without requirement on the kernel).
%else
%description run
This package is a stub instead of RPM helper to run QEMU inside hasher
on supported architectures (this one (%_arch) is unsupported).
%endif

%package createimage
Summary: Filetrigger to create ext4 image for vm-run
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description createimage
This is optional package containing a filetrigger to create an ext4 image
at "/tmp/vm-ext4.img" out of your hasher root to run vm-run with it as rootfs.

%package checkinstall
Summary: Checkinstall for vm-run
Group: Development/Other
BuildArch: noarch
%if "%_priority_distbranch" == "sisyphus"
%ifarch %supported_arches
Requires(post): busybox
%endif
%endif
Requires(post): %name-createimage = %EVR
Requires(post): iproute2
Requires(post): iputils
Requires(post): procps
Requires(post): time

%description checkinstall
Run checkinstall tests for vm-run.

%prep
%setup

%ifarch %supported_arches
%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
CFLAGS="%optflags" make

# This is pre-install syntax check for bash scripts. This does not
# run any functional tests.
make shellcheck
%else
# Still useful to verify stub script even in absence of shellcheck.
bash -n vm-run
%endif

%install
%ifnarch %supported_arches
install -D -p -m 0755 vm-run-stub %buildroot%_bindir/vm-run
%else
install -D -p -m 0755 vm-run      %buildroot%_bindir/vm-run
install -D -p -m 0755 vm-create-image %buildroot%_bindir/vm-create-image
install -D -p -m 0755 vm-initrd   %buildroot%_bindir/vm-initrd
install -D -p -m 0755 vm-init     %buildroot%_libexecdir/vm-run/vm-init
install -D -p -m 0755 initrd-init %buildroot%_libexecdir/vm-run/initrd-init
install -D -p -m 0755 fakesudo    %buildroot%_libexecdir/vm-run/vm-fakesudo
install -D -p -m 0755 filetrigger %buildroot%_rpmlibdir/vm-run.filetrigger
install -D -p -m 0755 createimage %buildroot%_rpmlibdir/z-vm-createimage.filetrigger
install -Dp bash_completion %buildroot%_sysconfdir/bashrc.d/vm_completion.sh
install -D -p -m 0755 vm-resize   %buildroot%_bindir/vm-resize
%endif
install -D -p -m 0755 kvm-ok      %buildroot%_bindir/kvm-ok
install -Dp checkinstall.sh %buildroot%_libexecdir/vm-run.ci/checkinstall

%pre run
# Only allow to install inside of hasher.
[ -d /.host -a -d /.in -a -d /.out ] || {
        echo >&2 'rpm-build-vm-run is not allowed outside hasher environments'
        exit 1
}

%files

%files checkinstall
%_libexecdir/vm-run.ci

%files createimage
%ifarch %supported_arches
%_rpmlibdir/z-vm-createimage.filetrigger
%endif

%files run
%_bindir/vm-run
%_bindir/kvm-ok

%ifarch %supported_arches
%_bindir/vm-initrd
%_bindir/vm-resize
%_bindir/vm-create-image
%_libexecdir/vm-run
%_rpmlibdir/vm-run.filetrigger
%_sysconfdir/bashrc.d/vm*.sh

%post run
# Call filetrigger for the past kernels and packages.
find /boot | %_rpmlibdir/vm-run.filetrigger

%post checkinstall -p %_libexecdir/vm-run.ci/checkinstall

%check
# Verify availability of KVM in girar & beehiver.
ls -l /dev/kvm && test -w /dev/kvm

%else
# Test stub.
%post checkinstall
set -ex
vm-run --unknown-option date
vm-run -- exit 1
vm-run --stub-exit=7 && exit 1 || test $? -eq 7
%endif

%changelog
