%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: rpm-build-file
Version: 4.26
Release: alt19

Summary: A utility for determining file types (for rpm-build)
License: BSD-style
Group: File tools
Url: http://www.darwinsys.com/file/

Summary(ru_RU.UTF-8): Утилита для определения типов файлов
BuildPreReq: zlib-devel

# ftp://ftp.astron.com/pub/file/file-%version.tar.gz
Source: file-%version.tar
Source1: magic.local

Patch: file-%version-%release.patch

%description
The file command is used to identify a particular file according to the
type of data contained by the file.  file can identify many different
file types, including ELF binaries, system libraries, RPM packages, and
different graphics formats.

%prep
%setup -n file-%version
%patch -p1
sed -i 's!/etc/magic:!!' src/Makefile.am
sed -i 's/lib_LTLIBRARIES/noinst_LTLIBRARIES/' src/Makefile.am
sed -i 's/include_HEADERS/noinst_HEADERS/' src/Makefile.am
sed -i 's/man_MANS/noinst_MANS/' doc/Makefile.am
sed -i '/pkgdata_DATA/s/magic.mgc magic/magic.mgc/' magic/Makefile.am
sed -i '/AC_INIT/s/file/file4/' configure.ac

%build
%ifarch x86_64
%add_optflags -fanalyzer
%endif
%autoreconf
%configure --program-suffix=4
grep -FZl sparc magic/Magdir/* |
	xargs -r0 sed -i 's/sparc/SPARC/g' --
# SMP-incompatible build.
make

%install
%makeinstall_std

# Test for correct identification of Perl modules
find /usr/*/perl5 -type f -name '*.p[lmh]' |
%buildroot%_bindir/file4 \
	-m %buildroot%_datadir/file4/magic -f - >test.out
grep -q ' [Pp]erl.* text' test.out
grep -v ' text' test.out && exit 1

%check
make -k check
date | xz -c > a.xz
%buildroot%_bindir/file4 -m %buildroot%_datadir/file4/magic -z a.xz |
	grep -Fz 'a.xz: ASCII text (xz compressed data)'

%files
%_bindir/file4
%_datadir/file4
%doc COPYING

%changelog
