%define optflags_lto %nil

%define git_ver 18170
%define git_commit 23b339d410fafc21326502d381b4b03611fa294b

%define asmjit_commit 416f7356967c1f66784dc1580fe157f9406d8bff
%define yaml_cpp_commit 456c68f452da09d8ca84b375faa2b1397713eaba
%define soundtouch_commit 3982730833b6daefe77dcfb32b5c282851640c17
%define fusion_version 1.2.8
%define gamemode_version 1.8.2

Name: rpcs3
Version: 0.0.38
Release: alt1

Summary: PS3 emulator/debugger
License: GPLv2
Group: Emulators

Url: https://%name.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64

# https://github.com/RPCS3/%name/archive/v%version/%name-%version.tar.gz
Source0: %name-%version.tar
# https://github.com/RPCS3/asmjit/archive/%asmjit_commit/asmjit-%asmjit_commit.tar.gz
Source1: asmjit-%asmjit_commit.tar
# https://github.com/RPCS3/yaml-cpp/archive/%yaml_cpp_commit/yaml-cpp-%yaml_cpp_commit.tar.gz
Source2: yaml-cpp-%yaml_cpp_commit.tar
# https://github.com/RPCS3/soundtouch/archive/%soundtouch_commit/soundtouch-%soundtouch_commit.tar.gz
Source3: soundtouch-%soundtouch_commit.tar
# https://github.com/xioTechnologies/Fusion/archive/v%fusion_version/Fusion-%fusion_version.tar.gz
Source4: Fusion-%fusion_version.tar
# https://github.com/FeralInteractive/gamemode/archive/%gamemode_version/gamemode-%gamemode_version.tar.gz
Source5: gamemode-%gamemode_version.tar

BuildRequires: /proc
BuildRequires: alt-os-release
BuildRequires: clang
BuildRequires: clang-tools
BuildRequires: glslang-devel
BuildRequires: glslc
BuildRequires: libGLEW-devel
BuildRequires: libSDL2-devel
BuildRequires: libSDL3-devel
BuildRequires: libcubeb-devel
BuildRequires: libcurl-devel
BuildRequires: libedit-devel
BuildRequires: libevdev-devel
BuildRequires: libfaudio-devel
BuildRequires: libffi-devel
BuildRequires: libflatbuffers-devel
BuildRequires: libhidapi-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libopenal-devel
BuildRequires: libopencv-devel
BuildRequires: libpng-devel
BuildRequires: libpugixml-devel
BuildRequires: librtmidi-devel
BuildRequires: libspirv-tools-devel
BuildRequires: libstb-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libvulkan-devel
BuildRequires: libvulkan-memory-allocator-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: libwolfssl-devel
BuildRequires: libxml2-devel
BuildRequires: libzstd-devel
BuildRequires: lld
BuildRequires: llvm
BuildRequires: llvm-devel
BuildRequires: qt6-multimedia-devel
BuildRequires: qt6-svg-devel
BuildRequires: xml-utils

%description
The world's first free and open-source PlayStation 3 emulator/debugger, written in C++ for Windows and Linux.

%prep
%setup -b 1 -b 2 -b 3 -b 4 -b 5

%__mv -Tf ../asmjit-%asmjit_commit 3rdparty/asmjit/asmjit
%__mv -Tf ../yaml-cpp-%yaml_cpp_commit 3rdparty/yaml-cpp/yaml-cpp
%__mv -Tf ../soundtouch-%soundtouch_commit 3rdparty/SoundTouch/soundtouch
%__mv -Tf ../Fusion-%fusion_version 3rdparty/fusion/fusion
%__mv -Tf ../gamemode-%gamemode_version 3rdparty/feralinteractive/feralinteractive

#Generate Version Strings
GIT_VERSION=$(echo %git_ver)
GIT_COMMIT=$(echo %git_commit)

echo "// This is a generated file.

#define RPCS3_GIT_VERSION \"$GIT_VERSION-${GIT_COMMIT:0:8}\"
#define RPCS3_GIT_BRANCH \"master\"
#define RPCS3_GIT_FULL_BRANCH \"RPCS3/rpcs3/master\"

// If you don't want this file to update/recompile, change to 1.
#define RPCS3_GIT_VERSION_NO_UPDATE 1
" > %name/git-version.h

%build
%add_optflags -I%_includedir/stb

export CC="clang"
export CXX="clang++"
export RANLIB="llvm-ranlib"
export AR="llvm-ar"
export NM="llvm-nm"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DUSE_NATIVE_INSTRUCTIONS:BOOL=OFF \
	-DUSE_SYSTEM_CUBEB:BOOL=ON \
	-DUSE_SYSTEM_FAUDIO:BOOL=ON \
	-DUSE_SYSTEM_FFMPEG:BOOL=ON \
	-DUSE_SYSTEM_FLATBUFFERS:BOOL=ON \
	-DUSE_SYSTEM_GLSLANG:BOOL=ON \
	-DUSE_SYSTEM_HIDAPI:BOOL=ON \
	-DUSE_SYSTEM_LIBPNG:BOOL=ON \
	-DUSE_SYSTEM_LIBUSB:BOOL=ON \
	-DUSE_SYSTEM_MINIUPNPC:BOOL=ON \
	-DUSE_SYSTEM_PUGIXML:BOOL=ON \
	-DUSE_SYSTEM_RTMIDI:BOOL=ON \
	-DUSE_SYSTEM_VULKAN_MEMORY_ALLOCATOR:BOOL=ON \
	-DUSE_SYSTEM_WOLFSSL:BOOL=ON \
	-DUSE_SYSTEM_ZSTD:BOOL=ON \
	-DLLVM_DIR:PATH=$(llvm-config --cmakedir) \
	-GNinja \
	-Wno-dev

%cmake_build

%install
%cmake_install

%__rm -rf %buildroot%_datadir/%name/{git,test}

%files
%doc LICENSE README.md
%_bindir/%name
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/%name
%_datadir/metainfo/%name.metainfo.xml

%changelog
