%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

%global _zig_cache_dir %_builddir/zig-cache

Name: river
Summary: A dynamic tiling Wayland compositor
Version: 0.3.9
Release: alt1
License: GPL-3.0
Group: Graphical desktop/Other
Url: https://isaacfreund.com/software/river
Vcs: https://codeberg.org/river/river

Source0: %name-%version.tar
Source1: vendor.tar
ExclusiveArch: %zig_arches

BuildRequires(pre): rpm-macros-zig

# Generated by gear-buildreq
BuildRequires: alt-os-release clang libevdev-devel libinput-devel libwayland-client-devel libwlroots0.18-devel libxkbcommon-devel python-modules-encodings python3-dev wayland-protocols zig

# Hand-picked
BuildRequires: xorg-xwayland scdoc

%description
River is a dynamic tiling wayland compositor that takes inspiration
from dwm and bspwm.

%package protocols-devel
Summary: Protocol files for the river wayland compositor
Group: Development/Other

%description protocols-devel
%summary.

%prep
%setup -a1
mv ./vendor %_zig_cache_dir

%build
%zig_build \
    -Dpie \
    -Dxwayland

%install
%zig_install \
    -Dpie \
    -Dxwayland

install -D -m755 -pv example/init %buildroot%_datadir/%name/init.example
install -D -m644 -pv contrib/%name.desktop %buildroot%_datadir/wayland-sessions/%name.desktop

%check
%zig_test

%files
%doc README.md LICENSE
%_bindir/river
%_bindir/riverctl
%_bindir/rivertile
%dir %_datadir/%name
%_datadir/%name/init.example
%_datadir/wayland-sessions/%name.desktop
%_mandir/man1/river.1*
%_mandir/man1/riverctl.1*
%_mandir/man1/rivertile.1*
%_datadir/bash-completion/completions/riverctl
%_datadir/fish/vendor_completions.d/riverctl.fish
%_datadir/zsh/site-functions/_riverctl

%files protocols-devel
%_datadir/pkgconfig/river-protocols.pc
%dir %_datadir/river-protocols
%_datadir/river-protocols/*.xml

%changelog
