%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define ver_major 0.5
%define rdn_name info.olasagasti.revelation

%def_enable check

Name: revelation
Version: %ver_major.6
Release: alt1

Summary: Password manager for the GNOME desktop
License: GPL-2.0
Group: Graphical desktop/GNOME
Url: http://revelation.olasagasti.info/

Vcs: https://github.com/mikelolasagasti/revelation.git

%if_disabled snapshot
Source: https://github.com/mikelolasagasti/%name/archive/%name-%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

%define python_ver 3.10
%define gtk_ver 3.22

Requires: python3-module-pygobject3
Requires: dconf
Requires: libgtk+3-gir >= %gtk_ver

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson shared-mime-info-devel
BuildRequires: libgtk+3-gir-devel >= %gtk_ver
BuildRequires: python3-module-pygobject3-devel
BuildRequires: python3-module-pycryptodomex
BuildRequires: python3-module-pwquality
BuildRequires: python3-module-defusedxml
%{?_enable_check:BuildRequires: desktop-file-utils %_bindir/appstreamcli}

%description
Revelation is a password manager for the GNOME desktop. It stores all
your accounts and passwords in a single, secure place, and gives you
access to it through a user-friendly graphical interface.

%prep
%setup -n %name%{?_disable_snapshot:-%name}-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

desktop-file-install --dir %buildroot%_desktopdir \
    --remove-category=Utility \
    --add-category=Settings \
    --add-category=X-PersonalSettings \
    --add-category=GTK \
    %buildroot%_desktopdir/%rdn_name.desktop

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%rdn_name.desktop
%python3_sitelibdir/%name/
%_datadir/mime/packages/revelation.xml
%_datadir/%name
%_iconsdir/hicolor/*x*/*/*.png
%_iconsdir//hicolor/scalable/*/*.svg
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.metainfo.xml

%changelog
