%define _unpackaged_files_terminate_build 1
%def_without tests
%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_disable qtwebengine
%endif

Name:    retext
Version: 8.1.0
Release: alt1
License: GPL-3.0+
Summary: Text editor for Markdown and reStructuredText
Summary(de): Texteditor für Markdown und reStructuredText
Group:   Editors
URL:     https://github.com/retext-project/retext

Source0: %name-%version.tar
Source1: %name.1

AutoProv:yes,nopython3

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): python3-devel
BuildRequires(pre): rpm-macros-qt6
BuildRequires: python3-module-setuptools
BuildRequires: /dev/pts
BuildRequires: python3-module-markups
BuildRequires: python3-module-docutils
BuildRequires: python3-module-enchant
BuildRequires: python3-module-markdown
BuildRequires: libpng-devel
BuildRequires: librsvg-devel
BuildRequires: librsvg-utils
BuildRequires: ImageMagick-tools
BuildRequires: qt6-tools-devel

%if_with tests
BuildRequires:  libappstream-glib
%endif

%py3_requires docutils enchant markdown mdx_math chardet pygments
%add_python3_req_skip FakeVim
%if_enabled qtwebengine
%add_python3_req_skip PyQt6.QtWebKit PyQt6.QtWebKitWidgets
%else
%add_python3_req_skip PyQt6.QtWebEngineCore PyQt6.QtWebEngineWidgets
%endif

%description
ReText is a simple but powerful text editor for Markdown and
reStructuredText.

%description -l de
ReText ist ein einfacher, aber leistungsfähiger Texteditor
für Markdown und reStructuredText.

%prep
%setup

%build
export PATH=%_qt6_bindir:$PATH
%python3_build_debug

%install
%python3_install
if [ "%python3_sitelibdir" != "%python3_sitelibdir_noarch" ] ; then
    mkdir -p %buildroot/%python3_sitelibdir
    mv %buildroot/%python3_sitelibdir_noarch/* %buildroot/%python3_sitelibdir/
fi

install -Dm 0644 %SOURCE1 %buildroot/%_man1dir/%name.1

# Generate resized icons
pushd ReText/icons
mkdir -p %buildroot/%_datadir/icons/hicolor/{16x16,22x22,24x24,32x32,48x48,64x64,72x72,96x96,128x128,scalable}/apps
for s in 16x16 22x22 24x24 32x32 48x48 64x64 72x72 96x96 128x128
do
    convert ./retext.png -resize $s %buildroot/%_datadir/icons/hicolor/$s/apps/retext.png
done
install -p -m 0644 retext.svg %buildroot/%_datadir/icons/hicolor/scalable/apps
popd

%find_lang retext --with-man

%check
%if_with tests
appstream-util validate-relax --nonet %buildroot%_datadir/metainfo/*.metainfo.xml ||:
python3 setup.py test
%endif

%files -f retext.lang
%doc changelog.md configuration.md README.md LICENSE_GPL
%_bindir/%name
%_datadir/metainfo/*.metainfo.xml
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/*.1*
%python3_sitelibdir/ReText/
%python3_sitelibdir/*egg-info

%changelog
