%def_enable check
%define _localstatedir /var
%define _libexecdir %_prefix/libexec

Name: realmd
Version: 0.17.1
Release: alt8
Summary: Kerberos realm enrollment service
License: LGPLv2+
Group: Security/Networking
Url: http://www.freedesktop.org/software/realmd/
Source: %name-%version.tar
Source2: realmd.conf
Patch: %name-%version.patch

BuildRequires: intltool >= 0.35.0
BuildRequires: pkgconfig(glib-2.0) >= 2.32.0 pkgconfig(gio-2.0) >= 2.32.0 pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(polkit-gobject-1)
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: /usr/bin/krb5-config
BuildRequires: libldap-devel
BuildRequires: xsltproc xmlto
BuildRequires: /usr/bin/net
%{?_enable_check:BuildRequires: python3-devel}
Requires: polkit
Requires: packagekit
Conflicts: oddjob-mkhomedir < 0.34.7-alt2

%description
realmd is a DBus system service which manages discovery and enrollment in realms
and domains like Active Directory or IPA. The control center uses realmd as the
back end to 'join' a domain simply and automatically configure things correctly.

%package devel-docs
Summary: Developer documentation files for %name
Group: Development/Documentation

%description devel-docs
The %name-devel package contains developer documentation for developing
applications that use %name.

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--disable-static

%make_build

%install
%makeinstall_std

%find_lang %name
mkdir -p %buildroot%_sysconfdir
install -m755 -D service/realmd-altlinux-helper %buildroot%_prefix/lib/realmd/
install -m0644 -D %SOURCE2 %buildroot%_sysconfdir/

%check
%make check

%files -f realmd.lang
%doc AUTHORS COPYING NEWS README
%config(noreplace) %_sysconfdir/realmd.conf
%_sbindir/realm
%_prefix/lib/realmd
%_libexecdir/realmd
%_unitdir/realmd.service
%_datadir/dbus-1/system-services/org.freedesktop.realmd.service
%_datadir/dbus-1/system.d/org.freedesktop.realmd.conf
%_datadir/polkit-1/actions/org.freedesktop.realmd.policy
%_man8dir/realm.*
%_man5dir/realmd.conf.*
%_cachedir/realmd

%files devel-docs
%doc %_datadir/doc/realmd/

%changelog
