%define qdoc_found %{expand:%%(if [ -e %_qt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}

%global qt_module qtx11extras

Name: qt5-x11extras
Version: 5.15.17
Release: alt1

Group: System/Libraries
Summary: Qt5 - X11 support library
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-build-ubt rpm-macros-qt5 qt5-tools
BuildRequires: gcc-c++ glibc-devel qt5-base-devel

%description
The X11 Extras module provides features specific to platforms using X11, e.g.
Linux and UNIX-like systems including embedded Linux systems that use the X
Window System.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
Requires: libXScrnSaver-devel libXcomposite-devel libXcursor-devel
Requires: libXdamage-devel libXdmcp-devel libXft-devel libXinerama-devel
Requires: libXmu-devel libXpm-devel libXrandr-devel libXtst-devel
Requires: libXv-devel libXxf86misc-devel libXxf86vm-devel
Requires: libxkbfile-devel libxcbutil-keysyms-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
BuildArch: noarch
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-x11extras
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libqt5-core = %_qt5_version
Provides: qt5-qtx11extras = %version-%release
%description -n libqt5-x11extras
%summary

%prep
%setup -n %qt_module-everywhere-src-%version
syncqt.pl-qt5 -version %version

%build
%qmake_qt5
%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_qt5
%make INSTALL_ROOT=%buildroot install_docs ||:

%files common
%files -n libqt5-x11extras
%doc LICENSE*EXCEPT*
%_qt5_libdir/libQt?X11Extras.so.*

%files doc
%if %qdoc_found
%_qt5_docdir/*
%endif

%files devel
%_qt5_headerdir/QtX11Extras/
%_qt5_libdatadir/libQt*.so
%_qt5_libdir/libQt*.so
%_qt5_libdir/libQt*.prl
%_qt5_libdatadir/libQt*.prl
%_qt5_libdir/cmake/Qt*/
%_qt5_libdir/pkgconfig/Qt*.pc
%_qt5_archdatadir/mkspecs/modules/qt_*.pri

%changelog
