
Name: qstardict
Version: 4.0.0
Release: alt1

Group: System/Internationalization
Summary: QStarDict Qt clone of StarDict
License: GPL-3.0-or-later
Url: http://qstardict.ylsoftware.com

Requires: qt6-translations

Provides: stardict = 2.4.5
Provides: qstardict-kde5 = %EVR
Obsoletes: qstardict-kde5 < %EVR

Source: %name-%version.tar
Source10: qstardict-ru_RU.ts
Patch1: alt-l10n.patch
Patch2: alt-ftbfs.patch
Patch3: alt-help-not-avail.patch

BuildRequires(pre): rpm-macros-qt6
BuildRequires: glib2-devel qt6-base-devel qt6-5compat-devel qt6-tools zlib-devel libzim-devel
BuildRequires: desktop-file-utils

%description
QStarDict is a dictionary application for learning foreign languages written
using Qt.

The main features:
* Support of Kiwix dictionaries
* Support of StarDict 2.x and 3.x dictionaries
* Background mode
* Showing translations for words selected by mouse in any application in
  a popup window
* Pronuncation of words

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
#cat %SOURCE10 > translations/qstardict-ru_RU.ts

%build
%qmake_qt6 \
    PLUGINS_DIR=%_libdir/%name/plugins \
    DOCS_DIR=%_datadir/%name/docs \
    #
%make

%install
%install_qt6

LC_ALL=en_US.UTF-8 desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	--add-category=TextTools \
	--add-category=Office \
	--set-key="Comment[ru]" \
	--set-value="Qt-версия словаря StarDict" \
	%buildroot%_desktopdir/qstardict.desktop

%find_lang %name --all-name --with-qt

%files -f %{name}.lang
%doc AUTHORS COPYING ChangeLog THANKS
%_bindir/%name
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/docs/
%_desktopdir/*.desktop
%_datadir/pixmaps/qstardict.*
%dir %_libdir/%name/
%dir %_libdir/%name/plugins/
%_libdir/%name/plugins/*.so

%changelog
