%define ltr libtorrent-rasterbar-devel
%define rel alt1

Name: qbittorrent
Version: 5.1.4
Epoch: 1
Release: %rel

Summary: qBittorrent is a bittorrent client written in C++ / Qt6 using the good libtorrent library
Summary(ru_RU.UTF-8): qBittorrent - bittorrent клиент написанный на C++ / Qt6, использующий библиотеку libtorrent.
License: GPLv2+
Group: Networking/File transfer
Url: http://qbittorrent.org

Source: %name-%version.tar.gz
Patch3500: ax_boost_base-loongarch64.patch

BuildPreReq: desktop-file-utils
BuildRequires(pre): rpm-build-ninja
BuildRequires: boost-devel boost-filesystem boost-filesystem-devel boost-datetime boost-program-options-devel boost-asio-devel
BuildRequires: gcc-c++  qt6-base-devel qt6-tools qt6-svg-devel qt6-tools-devel qt6-qtbase-gui libqt6-gui cmake 
# qt5-base-devel qt5-tools qt5-svg-devel systemd systemd-devel
BuildRequires: GeoIP-Lite-Country
BuildRequires: libnotify-devel
BuildRequires: zlib-devel
BuildRequires: gnu-config libappstream-glib 
BuildRequires: rpm-build-python3 rpm-macros-python3

%if "%rel" == "alt0.M80P"
%define ltr libtorrent-rasterbar9-devel
%endif
BuildRequires: %ltr

Requires: python3-module-ctypesgen qt6-svg
Requires: GeoIP-Lite-Country

%description
qBittorrent is a bittorrent client written in C++ / Qt6 using the good
libtorrent-rasterbar library (By Arvid Nordberg). qBittorrent is
free / open-source software released under the GNU GPL license.
qBittorrent aims to be a good alternative to all other bittorrent
clients. The Author is Christophe Dumez, French Student in
computer science (IT).

%description -l ru_RU.UTF8
qBittorrent - клиент bittorrent написанный на C++ / Qt6, использующий
библиотеку libtorrent-rasterbar (Arvid Nordberg). qBittorrent свободное
ПО с открытым исходным кодом, распространяющийся под лицензией GNU GPL.
qBittorrent стремится быть хорошей альтернативой всем другим bittorrent
клиентам. Автор Christophe Dumez, французский студент в области IT.

%package nox
Summary: qbittorrent version without GUI (WebUI version)
Group: Networking/File transfer
BuildRequires: systemd systemd-devel
%description nox
WebUI version of qbittorrent.

Default is to listen on tcp/8080 with admin/adminadmin credentials

%description -l ru_RU.UTF8 nox
Веб-интерфейс для qbittorrent

По умолчанию открывается порт 8080 с логином/паролем admin/adminadmin

%prep
%setup -q
#patch3500 -p1

%ifarch %e2k
sed -i "1i #include <cstdlib>\nnamespace std { using ::aligned_alloc; }" \
	src/{base/{bittorrent,rss},app,gui{,/properties,/rss,/search},webui/api}/*.cpp \
	src/base/{tagset,bittorrent/{filterparserthread,session}}.h \
	src/gui/{addnewtorrentdialog,properties/peersadditiondialog}.h
sed -i -E '/inline namespace/h;/^ *Q_ENUM_NS\(/{G;s/Q_ENUM_NS/&2/;s/\)\n.*inline namespace/,/;s/$/)/};/#include <QMeta(Type|Enum)>/a #define Q_ENUM_NS2(ENUM,NAME) Q_ENUMS(ENUM) inline Q_DECL_CONSTEXPR const QMetaObject *qt_getEnumMetaObject(ENUM) noexcept { return &NAME::staticMetaObject; } inline Q_DECL_CONSTEXPR const char *qt_getEnumName(ENUM) noexcept { return #ENUM; }' \
	src/base/bittorrent/*.h
%endif

%build

mkdir build-nox
pushd build-nox
%cmake \
 -DSYSTEMD=ON \
 -Wno-dev \
 -GNinja \
 -DQT6=ON \
 -DGUI=OFF \
 ..
%cmake_build
popd

# Build gui version
mkdir build
pushd build
%cmake \
 -Wno-dev \
 -DQT6=ON \
 -GNinja \
 ..
%cmake_build
popd

%install
# install headless version
pushd build-nox
%cmake_install
popd

# install gui version
pushd build
%cmake_install
popd

desktop-file-install \
  --dir=%{buildroot}%{_datadir}/applications/ \
  %{buildroot}%{_datadir}/applications/org.qbittorrent.qBittorrent.desktop



%files nox
%_bindir/%name-nox
%_man1dir/%name-nox.*
%_unitdir/qbittorrent-nox@.service

%files
%doc AUTHORS COPYING INSTALL README.* Changelog
%_bindir/%name
%_desktopdir/*
%_man1dir/%name.*
/usr/share/man/ru/man1/qbittorrent.1.*
/usr/share/man/ru/man1/qbittorrent-nox.1.*
%_datadir/icons/hicolor/*/*/*
%_datadir/metainfo/*.xml

%changelog
