%define _unpackaged_files_terminate_build 1
%define pypi_name zstd
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.5.7.2
Release: alt1

Summary: Zstd Bindings for Python

License: BSD
Group: Development/Python3
Url: https://pypi.org/project/zstd/
Vcs: https://github.com/sergey-dryabzhinsky/python-zstd
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
BuildRequires: gcc
BuildRequires: libzstd-devel
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%endif

%description
Simple Python bindings for the Zstd compression library.

%prep
%setup
%autopatch -p1
# Remove bundled zstd library
rm -r zstd
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
export ZSTD_EXTERNAL=1
%pyproject_build

%install
%pyproject_install

%check
# there is no option to exclude tests via CLI
# speed tests check nothing but measure and report speed
rm tests/test_speed.py
%pyproject_run_unittest -v

%files
%doc README.rst LICENSE
%python3_sitelibdir/%mod_name.*.so
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
