%define _unpackaged_files_terminate_build 1
%define ns_name zope
%define mod_name deferredimport
%define pypi_name %ns_name.%mod_name

%def_with check

Name: python3-module-%pypi_name
Version: 5.1
Release: alt1
Summary: Allows you to perform imports names that will be resolved when used in the code
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.deferredimport/
Vcs: https://github.com/zopefoundation/zope.deferredimport.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
# switched to native namespace
Requires: python3-module-zope >= 3.3.0-alt10
# setuptools(pkg_resources) is used by namespace root which is not used in ALT
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
Often, especially for package modules, you want to import names for
convenience, but not actually perform the imports until necessary. The
zope.deferredimport package provided facilities for defining names in
modules that will be imported from somewhere else when used. You can
also cause deprecation warnings to be issued when a variable is used.

%prep
%setup
# don't package examples, remove the package *before* run tests to check if it's
# needed or not
rm -r src/zope/deferredimport/samples/
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc CHANGES.rst README.rst
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests.py
%exclude %python3_sitelibdir/%ns_name/%mod_name/__pycache__/tests.*

%changelog
