%define oname zodbpickle

%def_with check

Name: python3-module-%oname
Version: 4.3
Release: alt1
Summary: Fork of Python 3 pickle module

License: PSF-2.0 and ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zodbpickle
Vcs: https://github.com/zopefoundation/zodbpickle

Source: %name-%version.tar

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
%endif

%description
This package presents a uniform pickling interface for ZODB.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package presents a uniform pickling interface for ZODB.

This package contains tests for %oname.


%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

# Don't bother with development files
rm %buildroot%python3_sitelibdir/%oname/*.c

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd src/zodbpickle
python3 -m unittest -v
popd

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%changelog
