%define oname yamlsettings

%def_with check

Name: python3-module-%oname
Version: 2.1.2
Release: alt1

Summary: Yaml Settings Configuration Module
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/yamlsettings/
Vcs: https://github.com/KyleJamesWalker/yamlsettings.git

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pyaml
BuildRequires: python3-module-mock
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-six
%endif

%py3_provides %oname

%description
A library to help manage project settings, without having to worry about
accidentally checking non-public information, like api keys. Along with
simple environment variable support.

%prep
%setup

sed -i '/"nose",/d' setup.py
sed -i '/"pytest-runner",/d' setup.py

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info


%changelog
