%define oname xmlschema

%ifnarch ppc64le
%def_with check
%else
%def_without check
%endif
%def_without memory_profiler

Name: python3-module-%oname
Version: 4.2.0
Release: alt1

Summary: XML Schema validator and data conversion library

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/xmlschema
VCS: https://github.com/sissaschool/xmlschema

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(elementpath)
BuildRequires: python3(lxml)

%if_with check
BuildRequires: /proc
BuildRequires: python3(tox)
# these are optional
%{?memory_profiler BuildRequires: python3-module-memory_profiler}
BuildRequires: python3-module-mypy
BuildRequires: python3-module-jinja2
# lxml-stubs is not packaged yet
%endif

%description
The xmlschema library is an implementation of XML Schema for Python.

%prep
%setup
sed -i 's/license = "MIT"/license = {file = "LICENSE"}/' pyproject.toml
sed -i '/license-files/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
# Increase verbosity of check
sed -i 's/unittest/unittest -v/' tox.ini
%tox_check_pyproject

%files
%doc LICENSE README.rst
%_bindir/xmlschema-json2xml
%_bindir/xmlschema-validate
%_bindir/xmlschema-xml2json
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
