%define oname xlsxwriter

Name:    python3-module-%oname
Version: 3.2.9
Release: alt2
Summary: A Python module for creating Excel XLSX files
License: BSD
Group:   Development/Python3
Url:     https://github.com/jmcnamara/XlsxWriter
Packager: Python Development Team <python@packages.altlinux.org>

Source: %oname-%version.tar
#VCS: https://github.com/jmcnamara/XlsxWriter
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: time
# Provides py.test3 for us without the minor version:
BuildRequires: python3-module-pytest >= 3.0.5-alt2
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

Provides: python-module-%oname = %EVR
Obsoletes: python-module-%oname < %EVR

%description
XlsxWriter is a Python module for writing files in the Excel 2007+ XLSX
file format.

XlsxWriter can be used to write text, numbers, formulas and hyperlinks
to multiple worksheets and it supports features such as formatting and
many more.

%prep
%setup -n %oname-%version

%build
%pyproject_build

%install
%pyproject_install
pushd %buildroot%_bindir
for i in *; do
       cp "$i" "${i}3"
done
popd

%check
# .github/workflows/python-test.yml
%pyproject_run_pytest -vra

%files
%doc Changes *.md *.rst examples dev/performance
%_bindir/*.py*
%python3_sitelibdir/*

%changelog
