%define _unpackaged_files_terminate_build 1
%define modulename xcffib

%def_with check

Name: python3-module-%modulename
Version: 1.11.2
Release: alt1

Summary: A drop-in replacement for xpyb based on cffi
License: Apache-2.0
Group: Development/Python3
URL: https://github.com/tych0/xcffib

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-cffi
BuildRequires: xorg-xcbproto-devel

BuildRequires(pre): rpm-build-haskell-vendored
BuildRequires: ghc cabal-install

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: xorg-xvfb xeyes
%endif

Requires: libxcb

BuildArch: noarch

Source: %name-%version.tar

# Vendor
Patch0: %name-%version-alt.patch

%description
%summary

%prep
%setup
%patch0 -p1

%build
%cabal_vendor_build
%cabal_vendor_run xcffibgen -- --input /usr/share/xcb --output ./xcffib
touch ./xcffib/py.typed

cp ./module/*py ./xcffib/
XCBVER="$(pkg-config --modversion xcb-proto)"
sed -i "s/__xcb_proto_version__ = .*/__xcb_proto_version__ = \"$XCBVER\"/" xcffib/__init__.py
sed -i "s/__version__ = .*/__version__ = \"%version\"/" xcffib/__init__.py

%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc README.md
%python3_sitelibdir/%modulename/
%python3_sitelibdir/%{pyproject_distinfo %modulename}

%changelog
