%define pypi_name WSME
%define lpypi_name wsme
%def_with check
%def_without bootstrap

Name:           python3-module-%lpypi_name
Version:        0.12.1
Release:        alt2.1
Summary:        Web Services Made Easy
Group:          Development/Python3

License:        MIT
URL:            https://pypi.python.org/pypi/WSME
Source:        %lpypi_name-%version.tar
Patch:         %lpypi_name-namespace-disable.patch
BuildArch:      noarch

BuildRequires: rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-webob
BuildRequires: python3-module-simplegeneric
BuildRequires: python3-module-pytz
BuildRequires: python3-module-netaddr
BuildRequires: python3-module-importlib-metadata
BuildRequires: python3-module-flask
BuildRequires: python3-module-webtest
BuildRequires: python3-module-pecan-tests
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-flask-restful
BuildRequires: python3-module-transaction
%endif

#see wsmeext/soap/simplegeneric.py
Requires: python3-module-simplegeneric

%add_python3_req_skip flask
%add_python3_req_skip pecan
%add_python3_req_skip cherrypy
%add_python3_req_skip turbogears
%add_python3_req_skip sphinx

%if_with bootstrap
%add_python3_req_skip cherrypy.filters.basefilter
%add_python3_req_skip turbogears.startup turbogears.view
%endif

%description
Web Services Made Easy, simplifies the implementation of
multiple protocol REST web services by providing simple yet
powerful typing which removes the need to directly
manipulate the request and the response objects.

%prep
%setup -n %lpypi_name-%version
%patch

%build
%pyproject_build

%install
%pyproject_install

# Delete tests
rm -rv %buildroot%python3_sitelibdir/*/tests

%check
%tox_check_pyproject

%files
%python3_sitelibdir/wsme
%python3_sitelibdir/wsmeext
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
