%define _unpackaged_files_terminate_build 1
%define oname whoosh
%define descr \
Whoosh is a fast, featureful full-text indexing and searching library \
implemented in pure Python. Programmers can use it to easily add search \
functionality to their applications and websites. Every part of how \
Whoosh works can be extended or replaced to meet your needs exactly.

%def_with check

Name: python3-module-%oname
Version: 2.7.4
Release: alt4.1

Summary: Fast pure-Python indexing and search library
Group: Development/Python3

License: BSD
URL: https://bitbucket.org/mchaput/whoosh/wiki/Home
# hg clone https://bitbucket.org/mchaput/whoosh
Source: %oname-%version.tar
Patch0: whoosh-2.7.4-tests-Adapt-config-to-modern-Pytest.patch
Patch1: whoosh-2.7.4-fsa-Ignore-order-of-transitions-for-comparison.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

BuildArch: noarch

%add_python3_req_skip google
%add_python3_req_skip google.appengine.api
%add_python3_req_skip google.appengine.ext
%add_python3_req_skip whoosh.automata.fst
%filter_from_provides /^python3(whoosh.automata.nfa)/d
# ImportError: No module named 'whoosh.automata.fst'
%filter_from_provides /^python3(whoosh.filedb.gae)/d
# ImportError: No module named 'google'
%filter_from_provides /^python3(whoosh.support.bench)/d
# ImportError: cannot import name 'find_object'

%description
%descr

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install
cp -fR src/whoosh/query src/whoosh/matching %buildroot%python3_sitelibdir/%oname/

%check
%tox_check_pyproject

%files
%doc *.txt
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/%oname/util/testing.py*

%changelog
