%define _unpackaged_files_terminate_build 1
%define pypi_name validate-pyproject

%def_with check

Name: python3-module-%pypi_name
Version: 0.24.1
Release: alt1
Summary: Validation pyproject.toml files using JSON Schema
License: MPL-2.0 and MIT and BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/validate-pyproject
VCS: https://github.com/abravalheri/validate-pyproject.git
BuildArch: noarch
Source: %name-%version.tar
Source1: pyproject_deps.json
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata_extra all
%pyproject_builddeps_check
%endif

%description
Validation library and CLI tool for checking on 'pyproject.toml' files using
JSON Schema.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -o=addopts=-Wignore -m 'not uses_network'

%files
%doc README.rst
%_bindir/validate-pyproject
%python3_sitelibdir/validate_pyproject/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
