%define oname unidecode

%def_with check

Name: python3-module-%oname
Version: 1.4.0
Release: alt1.1
Summary: ASCII transliterations of Unicode text
License: GPLv2
Group: Development/Python3
Url: https://pypi.python.org/pypi/Unidecode/

# http://www.tablix.org/~avian/git/unidecode.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-pytest-mypy
%endif

%py3_provides %oname

%description
It often happens that you have text data in Unicode, but you need to
represent it in ASCII. For example when integrating with legacy code
that doesn't support Unicode, or for ease of entry of non-Roman names on
a US keyboard, or when constructing ASCII machine identifiers from
human-readable Unicode strings that should still be somewhat
intelligeble (a popular example of this is when making an URL slug from
an article title).

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE README.rst tools
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
