%define oname ujson

%def_with check

Name: python3-module-%oname
Version: 5.11.0
Release: alt1

Summary: Ultra fast JSON encoder and decoder for Python

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/ujson
VCS: https://github.com/esnme/ultrajson

Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++ libdouble-conversion-devel

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

%description
UltraJSON is an ultra fast JSON encoder and decoder written in pure C with
bindings for Python.

%prep
%setup
# Remove bundled double-conversion
rm -vrf deps

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export UJSON_BUILD_NO_STRIP=1
export UJSON_BUILD_DC_INCLUDES='%{_includedir}/double-conversion'
export UJSON_BUILD_DC_LIBS='-ldouble-conversion'
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE.txt *.md
%python3_sitelibdir/%oname.cpython-*.so
%python3_sitelibdir/%oname-%version.dist-info

%changelog
