%define oldname python-uinput

Name: python3-module-uinput
Version: 1.0.1
Release: alt1

Summary: Pythonic API to the Linux uinput kernel module

License: GPLv3
Group: Development/Python3
URL: https://pypi.org/project/python-uinput
VCS: https://github.com/pyinput/python-uinput

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: rdma-core-devel
BuildRequires: libudev-devel

# https://github.com/tuomasjjrasanen/python-uinput/issues/16
# setup.py parses /usr/include/linux/input.h
BuildRequires: glibc-kernheaders-generic

%description
Python-uinput is Python interface to the Linux uinput kernel module
which allows attaching userspace device drivers into kernel.

%prep
%setup

# Use unversioned .so
%__subst "s/libudev.so.0/libudev.so/" setup.py

# Hack off distutils dependency
sed -i 's/distutils.sysconfig as //' src/__init__.py

%build
%pyproject_build

%install
%pyproject_install

chmod a-x examples/*

%files
%doc COPYING examples
%python3_sitelibdir/python_uinput-%version.dist-info
%python3_sitelibdir/_libsuinput.*.so
%python3_sitelibdir/uinput/

%changelog
