%define pypi_name Twisted
%define major 24.11
%define prefx3 python3-module-twisted

Name: python3-module-twisted-core
Version: %major.0
Release: alt2

Summary: An asynchronous networking framework written in Python

Group: Development/Python3
License: MIT
URL: https://pypi.org/project/Twisted

Source: %name-%version.tar
Source1: README.ALT-ru_RU.UTF-8

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-incremental
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-fancy-pypi-readme

Requires: %prefx3-logger = %EVR
Obsoletes: %prefx3-lore <= %EVR
Provides: %prefx3-lore = %EVR
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
#py3_provides lore
Requires: python3-module-OpenSSL
#Requires: python3-module-autobahn

%add_python3_req_skip AppKit Carbon Foundation GDK PAM cfsupport
%add_python3_req_skip kqsyscall msvcrt pythoncom pywintypes win32api
%add_python3_req_skip win32com win32event win32file win32gui win32pipe
%add_python3_req_skip win32process win32security win32con CFNetwork
%add_python3_req_skip CoreFoundation
%add_python3_req_skip win32com.shell

BuildArch: noarch

%description
An extensible framework for Python programming, with special focus
on event-based network programming and multiprotocol integration.

It is expected that one day the project will expanded to the point
that the framework will seamlessly integrate with mail, web, DNS,
netnews, IRC, RDBMSs, desktop environments, and your toaster.

%package -n twisted-core-tools
Summary: Tools for Twisted Core (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Conflicts: python-module-twisted-core

%description -n twisted-core-tools
Tools for Twisted Core.


%package -n %prefx3-core-gui
Summary: GUI for Twisted Core (Python 3)
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip pyui gtk

%description -n %prefx3-core-gui
GUI for Twisted Core

%package -n %prefx3-core-gui-wx
Summary: GUI for Twisted Core (wxWidgets) (Python 3)
Group: Development/Python3
Requires: %name-gui = %EVR

%description -n %prefx3-core-gui-wx
GUI for Twisted Core (wxWidgets)

%package -n %prefx3-core-gui-tk
Summary: GUI for Twisted Core (TK) (Python 3)
Group: Development/Python3
Requires: %name-gui = %EVR

%description -n %prefx3-core-gui-tk
GUI for Twisted Core (TK)

%package -n %prefx3-core-gui-gnome
Summary: GUI for Twisted Core (Gnome) (Python 3)
Group: Development/Python3
Requires: %name-gui = %EVR

%description -n %prefx3-core-gui-gnome
GUI for Twisted Core (Gnome)

%package -n %prefx3-core-doc
Summary: Documentation for Twisted Core (Python 3)
Group: Documentation
BuildArch: noarch
Requires: %name = %EVR

%description -n %prefx3-core-doc
Documentation for Twisted Core.

%package -n %prefx3-core-zsh
Summary: Tab completion for Zsh and Twisted Core
Group: Shells
Requires: %name = %EVR
Requires: zsh

%description -n %prefx3-core-zsh
Tab completions for Zsh and Twisted Core.

%package -n %prefx3-news
Summary: Twisted News is an NNTP server and programming library (Python 3)
Group: Development/Python3
Requires: %prefx3-core = %EVR
Requires: %prefx3-mail = %EVR

%description -n %prefx3-news
Twisted is an event-based framework for internet applications.

Twisted News is an NNTP protocol (Usenet) programming library. The
library contains server and client protocol implementations. A simple
NNTP server is also provided.

%package -n %prefx3-lore
Summary: Twisted documentation system (Python 3)
Group: Development/Python3
Requires: %prefx3-core = %EVR
Requires: %prefx3-web = %EVR

%description -n %prefx3-lore
Twisted is an event-based framework for internet applications.

Lore is a complete documentation system based on XHTML and can generate
documentation into other formats such as PDF, HTML.

%package -n %prefx3-runner
Summary: Twisted Runner process management library and inetd replacement (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description -n %prefx3-runner
Twisted is an event-based framework for internet applications.

Twisted Runner contains code useful for persistent process management
with Python and Twisted, and has an almost full replacement for inetd.

%package -n %prefx3-mail
Summary: A Twisted Mail library, server and client (Python 3)
Group: Development/Python3
Requires: %prefx3-core = %EVR
Requires: %prefx3-names = %EVR
Conflicts: python-module-twisted-core-mail

%description -n %prefx3-mail
Twisted is an event-based framework for internet applications.

Twisted Mail contains high-level, efficient protocol implementations
for both clients and servers of SMTP, POP3, and IMAP4. Additionally,
it contains an "out of the box" combination SMTP/POP3 virtual-hosting
mail server. Also included is a read/write Maildir implementation and
a basic Mail Exchange calculator.

%package -n %prefx3-web
Summary: Twisted web server, programmable in Python 3
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip Tkinter SOAPpy

%description -n %prefx3-web
Twisted is an event-based framework for internet applications.

Twisted Web is a complete web server, aimed at hosting web
applications using Twisted and Python, but fully able to serve static
pages, also.

%package -n %prefx3-conch
Summary: Twisted SSHv2 implementation (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Conflicts: python-module-twisted-core-conch

%description -n %prefx3-conch
Twisted is an event-based framework for internet applications.

Conch is an SSHv2 implementation written in Python. SSH is a protocol designed
to allow remote access to shells and commands, but it is generic enough to
allow everything from TCP forwarding to generic filesystem access. Since conch
is written in Python, it interfaces well with other Python projects, such as
Imagination. Conch also includes a implementations of the telnet and vt102
protocols, as well as support for rudamentary line editing behaviors. A new
implementation of Twisted's Manhole application is also included, featuring
server-side input history and interactive syntax coloring.

%package -n %prefx3-conch-gui
Summary: GUI for Twisted Conch (Python 3)
Group: Development/Python3
Requires: %prefx3-conch = %EVR

%description -n %prefx3-conch-gui
GUI for Twisted Conch

%package -n %prefx3-names
Summary: A Twisted DNS implementation (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description -n %prefx3-names
Twisted is an event-based framework for internet applications.

Twisted Names is both a domain name server as well as a client
resolver library. Twisted Names comes with an "out of the box"
nameserver which can read most BIND-syntax zone files as well as a
simple Python-based configuration format. Twisted Names can act as an
authoritative server, perform zone transfers from a master to act as a
secondary, act as a caching nameserver, or any combination of
these. Twisted Names' client resolver library provides functions to
query for all commonly used record types as well as a replacement for
the blocking gethostbyname() function provided by the Python stdlib
socket module.

%package -n %prefx3-words
Summary: Twisted Words contains Instant Messaging implementations (Python 3)
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip java javax

%description -n %prefx3-words
Twisted is an event-based framework for internet applications.

Twisted Words contains implementations of many Instant Messaging
protocols, including IRC, Jabber, MSN, OSCAR (AIM & ICQ), TOC (AOL),
and some functionality for creating bots, inter-protocol gateways, and
a client application for many of the protocols.

In support of Jabber, Twisted Words also contains X-ish, a library for
processing XML with Twisted and Python, with support for a Pythonic DOM and
an XPath-like toolkit.

%package -n %prefx3-pair
Summary: Low-level networking transports and utilities (Python 3)
Group: Development/Python3
Requires: %prefx3-core
%add_python3_req_skip eunuchs

%description -n %prefx3-pair
Twisted is an event-based framework for internet applications.

Twisted Pair: The framework of your ethernet.
Low-level networking transports and utilities.

%package -n %prefx3-positioning
Summary: The Twisted positioning framework (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description -n %prefx3-positioning
Twisted is an event-based framework for internet applications.

The Twisted positioning framework.

%package -n %prefx3-logger
Summary: Classes and functions to do granular logging (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description -n %prefx3-logger
Twisted is an event-based framework for internet applications.

This package contains classes and functions to do granular logging.

%package -n %prefx3-core-tests
Summary: Unit tests for Twisted Core (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Provides: python3-module-twisted-core-test = %EVR
Obsoletes: python3-module-twisted-core-test
Conflicts: python-module-twisted-core-test
%add_python3_req_skip idonotexist cython_test_exception_raiser

%description -n %prefx3-core-tests
Unit tests for Twisted Core.


%prep
%setup

%build
%pyproject_build

# README.ALT
cp %SOURCE1 README.ALT-ru_RU.UTF-8

%install
%pyproject_install

# iocpreactor is a win32 reactor, so we can delete it
rm -rv %buildroot%python3_sitelibdir/twisted/internet/iocpreactor

# remove obsoleted gobject using (see ALT bug #41092)
rm -rv %buildroot%python3_sitelibdir/twisted/internet/glib2reactor.py
rm -rv %buildroot%python3_sitelibdir/twisted/internet/gtk2reactor.py

# Man pages
mkdir -p %buildroot%_man1dir/
cp -a docs/core/man/*.1 docs/mail/man/*.1 \
	docs/conch/man/*.1 \
	%buildroot%_man1dir/

rm -rfv docs/core/man docs/lore/man docs/mail/man docs/conch/man \
	docs/words/man

ln -s trial %buildroot%_bindir/trial-3

%check

%files -n twisted-core-tools
%_bindir/twist
%_bindir/twistd
%_bindir/pyhtmlizer
%_man1dir/pyhtmlizer.1*
%_man1dir/twistd.1*

%files
%doc LICENSE NEWS.rst README.rst
%doc README.ALT-ru_RU.UTF-8
%python3_sitelibdir/twisted-%version.dist-info
%dir %python3_sitelibdir/twisted/
%python3_sitelibdir/twisted/*.py
%python3_sitelibdir/twisted/__pycache__/
%python3_sitelibdir/twisted/python/_pydoctortemplates/

%python3_sitelibdir/twisted/application/
%exclude %python3_sitelibdir/twisted/application/test/
%exclude %python3_sitelibdir/twisted/application/twist/test/
%exclude %python3_sitelibdir/twisted/application/runner/test/
%python3_sitelibdir/twisted/cred/
%exclude %python3_sitelibdir/twisted/cred/test/
%python3_sitelibdir/twisted/_threads/
%exclude %python3_sitelibdir/twisted/_threads/test/
%python3_sitelibdir/twisted/enterprise/
%python3_sitelibdir/twisted/internet/
%exclude %python3_sitelibdir/twisted/internet/testing.py
%exclude %python3_sitelibdir/twisted/internet/test
%exclude %python3_sitelibdir/twisted/internet/tksupport.py
%exclude %python3_sitelibdir/twisted/internet/gireactor.py
%exclude %python3_sitelibdir/twisted/internet/wxreactor.py
%exclude %python3_sitelibdir/twisted/internet/__pycache__/wxreactor.*
%exclude %python3_sitelibdir/twisted/internet/wxsupport.py
%exclude %python3_sitelibdir/twisted/internet/__pycache__/wxsupport.*

%python3_sitelibdir/twisted/persisted/
%exclude %python3_sitelibdir/twisted/persisted/test

%dir %python3_sitelibdir/twisted/plugins/
%python3_sitelibdir/twisted/plugins/*.py*
%python3_sitelibdir/twisted/plugins/__pycache__/
%exclude %python3_sitelibdir/twisted/plugins/twisted_trial.py
%exclude %python3_sitelibdir/twisted/plugins/__pycache__/twisted_trial.*
%exclude %python3_sitelibdir/twisted/plugins/twisted_conch.py
%exclude %python3_sitelibdir/twisted/plugins/__pycache__/twisted_conch*
%exclude %python3_sitelibdir/twisted/plugins/twisted_web.py
%exclude %python3_sitelibdir/twisted/plugins/__pycache__/twisted_web.*

%dir %python3_sitelibdir/twisted/protocols/
%python3_sitelibdir/twisted/protocols/*.py*
%python3_sitelibdir/twisted/protocols/__pycache__/

%python3_sitelibdir/twisted/protocols/haproxy/
%exclude %python3_sitelibdir/twisted/protocols/haproxy/test/

%dir %python3_sitelibdir/twisted/python/
%python3_sitelibdir/twisted/python/*.py*
%python3_sitelibdir/twisted/python/__pycache__/


%python3_sitelibdir/twisted/scripts/
%exclude %python3_sitelibdir/twisted/scripts/test
%exclude %python3_sitelibdir/twisted/scripts/trial.py
%exclude %python3_sitelibdir/twisted/scripts/__pycache__/trial.*

%dir %python3_sitelibdir/twisted/spread/
%python3_sitelibdir/twisted/spread/*.py
%python3_sitelibdir/twisted/spread/__pycache__/

%python3_sitelibdir/twisted/tap/

%python3_sitelibdir/twisted/py.typed


%files -n %prefx3-core-doc
%doc docs/core

%files -n %prefx3-core-gui
#python3_sitelibdir/twisted/internet/pyuisupport.py*
#python3_sitelibdir/twisted/internet/gtk2reactor.py*
#python3_sitelibdir/twisted/internet/glib2reactor.py*

%files -n %prefx3-core-gui-gnome
%python3_sitelibdir/twisted/internet/gireactor.py

%files -n %prefx3-core-gui-wx
%python3_sitelibdir/twisted/internet/wxreactor.py
%python3_sitelibdir/twisted/internet/__pycache__/wxreactor.*
%python3_sitelibdir/twisted/internet/wxsupport.py
%python3_sitelibdir/twisted/internet/__pycache__/wxsupport.*

%files -n %prefx3-core-gui-tk
%python3_sitelibdir/twisted/internet/tksupport.py*

%files -n %prefx3-core-zsh
%python3_sitelibdir/twisted/python/twisted-completion.zsh


%files -n %prefx3-news
#python3_sitelibdir/twisted/news/
#exclude %python3_sitelibdir/twisted/news/test
#python3_sitelibdir/twisted/plugins/twisted_news.py*

%files -n %prefx3-runner
%python3_sitelibdir/twisted/runner/
%exclude %python3_sitelibdir/twisted/runner/test

%files -n %prefx3-mail
%doc docs/mail/*
%_bindir/mailmail
%_man1dir/mailmail.1*
%python3_sitelibdir/twisted/mail/
%exclude %python3_sitelibdir/twisted/mail/test

%files -n %prefx3-web
%doc docs/web/*
%python3_sitelibdir/twisted/web
%python3_sitelibdir/twisted/plugins/twisted_web.py
%python3_sitelibdir/twisted/plugins/__pycache__/twisted_web.*
%exclude %python3_sitelibdir/twisted/web/test

%files -n %prefx3-conch
%doc docs/conch/*
%_bindir/cftp
%_bindir/ckeygen
%_bindir/conch
%_man1dir/cftp.1*
%_man1dir/ckeygen.1*
%_man1dir/conch.1*
%python3_sitelibdir/twisted/conch/
%python3_sitelibdir/twisted/plugins/twisted_conch.py
%python3_sitelibdir/twisted/plugins/__pycache__/twisted_conch.*
%exclude %python3_sitelibdir/twisted/conch/ui
%exclude %python3_sitelibdir/twisted/conch/scripts/tkconch.py
%exclude %python3_sitelibdir/twisted/conch/scripts/__pycache__/tkconch.*

%exclude %python3_sitelibdir/twisted/conch/test

%files -n %prefx3-conch-gui
%_bindir/tkconch
%_man1dir/tkconch.1*
%python3_sitelibdir/twisted/conch/ui/
%python3_sitelibdir/twisted/conch/scripts/tkconch.py
%python3_sitelibdir/twisted/conch/scripts/__pycache__/tkconch.*

%files -n %prefx3-names
%doc docs/names/*
%python3_sitelibdir/twisted/names/
%exclude %python3_sitelibdir/twisted/names/test

%files -n %prefx3-words
%doc docs/words/*
%python3_sitelibdir/twisted/words/
%exclude %python3_sitelibdir/twisted/words/test

%files -n %prefx3-pair
%doc docs/pair/*
%python3_sitelibdir/twisted/pair/
%exclude %python3_sitelibdir/twisted/pair/test

%files -n %prefx3-positioning
%python3_sitelibdir/twisted/positioning/
%exclude %python3_sitelibdir/twisted/positioning/test

%files -n %prefx3-logger
%python3_sitelibdir/twisted/logger/
%exclude %python3_sitelibdir/twisted/logger/test

%files -n %prefx3-core-tests
%_bindir/trial
%_bindir/trial-3
%_man1dir/trial.1*
%python3_sitelibdir/twisted/trial/
%python3_sitelibdir/twisted/test
%python3_sitelibdir/twisted/python/test
%python3_sitelibdir/twisted/scripts/test
%python3_sitelibdir/twisted/internet/testing.py
%python3_sitelibdir/twisted/internet/test
%python3_sitelibdir/twisted/protocols/test
%python3_sitelibdir/twisted/protocols/haproxy/test
%python3_sitelibdir/twisted/plugins/twisted_trial.py
%python3_sitelibdir/twisted/plugins/__pycache__/twisted_trial.*
%python3_sitelibdir/twisted/scripts/trial.py
%python3_sitelibdir/twisted/scripts/__pycache__/trial.*
%python3_sitelibdir/twisted/application/test
%python3_sitelibdir/twisted/application/runner/test/
%python3_sitelibdir/twisted/application/twist/test
%python3_sitelibdir/twisted/runner/test
%python3_sitelibdir/twisted/web/test
%python3_sitelibdir/twisted/conch/test
%python3_sitelibdir/twisted/names/test
%python3_sitelibdir/twisted/pair/test
%python3_sitelibdir/twisted/cred/test
%python3_sitelibdir/twisted/_threads/test
%python3_sitelibdir/twisted/persisted/test
%python3_sitelibdir/twisted/positioning/test
%python3_sitelibdir/twisted/spread/test
%python3_sitelibdir/twisted/logger/test

%changelog
