%define _unpackaged_files_terminate_build 1
%define oname trytond

%def_enable check

Name: python3-module-%oname
Version: 7.6.10
Release: alt1

Summary: Tryton server
License: GPL-3
Group: Development/Python3
Url: https://www.tryton.org

Source0: %oname-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_enabled check
BuildRequires: python3-module-werkzeug
BuildRequires: python3-module-lxml
BuildRequires: python3-modules-sqlite3
BuildRequires: python3-module-sql
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-polib
BuildRequires: python3-module-defusedxml
BuildRequires: python3-module-relatorio
BuildRequires: python3-module-passlib
BuildRequires: python3-module-simpleeval
BuildRequires: python3-module-pwdlib
BuildRequires: python3-module-argon2-cffi
BuildRequires: python3-module-html2text
%endif

%py_provides %oname
%add_python3_req_skip __main__

%description
The server of the Tryton application platform. A three-tiers high-level
general purpose application platform written in Python and use
Postgresql as main database engine. It is the core base of an Open
Source ERP. It provides modularity, scalability and security.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-module-trytond_country

%description tests
The server of the Tryton application platform. A three-tiers high-level
general purpose application platform written in Python and use
Postgresql as main database engine. It is the core base of an Open
Source ERP. It provides modularity, scalability and security.

This package contains tests for %oname.

%prep
%setup -q -n %{oname}-%{version}

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir/
python3 -m unittest discover -s trytond.tests -v

%files
%doc CHANGELOG LICENSE README.rst COPYRIGHT
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test*

%files tests
%python3_sitelibdir/*/test*


%changelog
