%define oname tldextract

%def_with check

Name: python3-module-%oname
Version: 5.3.0
Release: alt1

Summary: Accurately separate the TLD from the registered domain and subdomains of a URL

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/tldextract
VCS: https://github.com/john-kurkowski/tldextract

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-requests-file
BuildRequires: python3-module-responses
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-syrupy
%endif

%py3_provides %oname

%description
tldextract accurately separates the gTLD or ccTLD (generic or country
code top-level domain) from the registered domain and subdomains of a
URL, using the Public Suffix List.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%check
# deprecated code check, see task #307207
sed -i 's/--pylint//g' tox.ini
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%tox_check_pyproject

%files
%doc *.md
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
