%define oname tifffile

%def_with check

Name: python3-module-%oname
Version: 2025.5.10
Release: alt1

Summary: Read and write TIFF(r) files

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/tifffile
VCS: https://github.com/cgohlke/tifffile

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-lxml
BuildRequires: python3-module-fsspec
%endif

%description
Tifffile is a Python library to
* store numpy arrays in TIFF (Tagged Image File Format) files, and
* read image and metadata from TIFF-like files used in bioimaging.

Image and metadata can be read from TIFF, BigTIFF, OME-TIFF, STK, LSM, SGI,
NIHImage, ImageJ, MicroManager, FluoView, ScanImage, SEQ, GEL, SVS, SCN, SIS,
ZIF (Zoomable Image File Format), QPTIFF (QPI), NDPI, and GeoTIFF files.

Numpy arrays can be written to TIFF, BigTIFF, OME-TIFF,
and ImageJ hyperstack compatible files in multi-page, memory-mappable, tiled,
predicted, or compressed form.

A subset of the TIFF specification is supported, mainly uncompressed and
losslessly compressed 8, 16, 32 and 64-bit integer, 16, 32 and 64-bit float,
grayscale and multi-sample images. Specifically, reading slices of image data,
CCITT and OJPEG compression, chroma subsampling without JPEG compression,
color space transformations, samples with differing types,
or IPTC and XMP metadata are not implemented.

TIFF(r), the Tagged Image File Format, is a trademark and under control of
Adobe Systems Incorporated. BigTIFF allows for files larger than 4 GB.
STK, LSM, FluoView, SGI, SEQ, GEL, QPTIFF, NDPI, and OME-TIFF,
are custom extensions defined by Molecular Devices (Universal Imaging Corporation),
Carl Zeiss MicroImaging, Olympus, Silicon Graphics International,
Media Cybernetics, Molecular Dynamics, PerkinElmer, Hamamatsu,
and the Open Microscopy Environment consortium, respectively.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONDONTWRITEBYTECODE=1
export PYTEST_ADDOPTS='-p no:cacheprovider'
export PYTHONPATH=%buildroot%python3_sitelibdir
export SKIP_LARGE=1
export SKIP_HTTP=1
%pyproject_run_pytest

%files
%doc LICENSE
%doc README.rst ACKNOWLEDGEMENTS.rst CHANGES.rst
%_bindir/lsm2bin
%_bindir/tifffile
%_bindir/tiff2fsspec
%_bindir/tiffcomment
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
