%define _unpackaged_files_terminate_build 1

%define modulename textual
%def_with check

# Common directory for documentation.
%define docdir %_docdir/%name-doc-%version

Name: python3-module-%modulename
Version: 5.0.1
Release: alt1

Summary: Textual is a Rapid Application Development framework for Python
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/textual/
Vcs: https://github.com/Textualize/textual.git
BuildArch: noarch

Source: %name-%version.tar
Source1: %pyproject_deps_config_name

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
##check filter code style, coverage, publishing, documentation modules
%add_pyproject_deps_check_filter mkdocs-exclude mkdocs-rss-plugin textual-dev types-setuptools
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Textual is a Rapid Application Development framework for Python.
Build sophisticated user interfaces with a simple Python API. Run
your apps in the terminal or a web browser!

%package -n %name-doc
Summary: Documentation for Textual
Group: Documentation
Requires: %name

%description -n %name-doc
Documentation for Textual. Textual is a Rapid Application
Development framework for Python. Build sophisticated user
interfaces with a simple Python API.

%prep
%setup
# for windows
rm src/textual/drivers/win32.py
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_poetry dev
%endif

%build
%pyproject_build

%install
%pyproject_install

# test_snapshots needs GUI mode, tested locally
# test_textual_env_var assert None is not None
%check
%pyproject_run_pytest \
    -n auto \
    --ignore=tests/snapshot_tests/test_snapshots.py \
    --ignore=tests/test_slug.py \
    --ignore=tests/text_area/test_languages.py \
    -k 'not textual_env_var'

%files
%python3_sitelibdir/%modulename
%python3_sitelibdir/%modulename-%version.dist-info
%doc README.md LICENSE

%files doc
%doc docs/* examples/

%changelog
